/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.wire.trait;

import codechicken.multipart.PartMap;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.api.energy.IConductor;
import universalelectricity.api.energy.IEnergyNetwork;
import universalelectricity.api.net.IConnector;

public class TraitConductor
extends TileMultipart
implements IConductor {
    public Set<IConductor> ueInterfaces = new HashSet<IConductor>();

    public void copyFrom(TileMultipart that) {
        super.copyFrom(that);
        if (that instanceof TraitConductor) {
            this.ueInterfaces = ((TraitConductor)that).ueInterfaces;
        }
    }

    public void bindPart(TMultiPart part) {
        super.bindPart(part);
        if (part instanceof IConductor) {
            this.ueInterfaces.add((IConductor)part);
        }
    }

    public void partRemoved(TMultiPart part, int p) {
        super.partRemoved(part, p);
        if (part instanceof IConductor) {
            this.ueInterfaces.remove(part);
        }
    }

    public void clearParts() {
        super.clearParts();
        this.ueInterfaces.clear();
    }

    public Object[] getConnections() {
        Iterator<IConductor> i$ = this.ueInterfaces.iterator();
        if (i$.hasNext()) {
            IConductor conductor = i$.next();
            return conductor.getConnections();
        }
        return null;
    }

    public IEnergyNetwork getNetwork() {
        return null;
    }

    public void setNetwork(IEnergyNetwork network) {
        for (IConductor conductor : this.ueInterfaces) {
            conductor.setNetwork((Object)network);
        }
    }

    public boolean canConnect(ForgeDirection direction, Object source) {
        for (IConductor conductor : this.ueInterfaces) {
            if (!conductor.canConnect(direction.getOpposite(), source)) continue;
            return true;
        }
        return false;
    }

    public long onReceiveEnergy(ForgeDirection from, long receive, boolean doReceive) {
        if (this.partMap(from.ordinal()) instanceof IConductor) {
            return ((IConductor)this.partMap(from.ordinal())).onReceiveEnergy(from, receive, doReceive);
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TMultiPart part;
            if (dir == from.getOpposite() || !this.ueInterfaces.contains(part = this.partMap(dir.ordinal()))) continue;
            return ((IConductor)part).onReceiveEnergy(from, receive, doReceive);
        }
        if (this.partMap(PartMap.CENTER.ordinal()) instanceof IConductor) {
            return ((IConductor)this.partMap(PartMap.CENTER.ordinal())).onReceiveEnergy(from, receive, doReceive);
        }
        return 0L;
    }

    public long onExtractEnergy(ForgeDirection from, long extract, boolean doExtract) {
        return 0L;
    }

    public float getResistance() {
        long energyLoss = 0L;
        if (this.ueInterfaces.size() > 0) {
            for (IConductor conductor : this.ueInterfaces) {
                energyLoss = (long)((float)energyLoss + conductor.getResistance());
            }
            energyLoss /= (long)this.ueInterfaces.size();
        }
        return energyLoss;
    }

    public long getCurrentCapacity() {
        long capacitance = 0L;
        if (this.ueInterfaces.size() > 0) {
            for (IConductor conductor : this.ueInterfaces) {
                capacitance += conductor.getCurrentCapacity();
            }
            capacitance /= (long)this.ueInterfaces.size();
        }
        return capacitance;
    }

    public IConductor getInstance(ForgeDirection from) {
        if (this.partMap(from.ordinal()) instanceof IConductor) {
            return (IConductor)this.partMap(from.ordinal());
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TMultiPart part = this.partMap(dir.ordinal());
            if (!this.ueInterfaces.contains(part)) continue;
            return (IConductor)((IConductor)part).getInstance(from);
        }
        if (this.partMap(PartMap.CENTER.ordinal()) instanceof IConductor) {
            return (IConductor)((IConnector)this.partMap(PartMap.CENTER.ordinal()));
        }
        return null;
    }
}

