/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.wire.trait;

import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cofh.api.energy.IEnergyHandler;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;
import resonantinduction.electrical.wire.PartConductor;

public class TraitEnergyHandler
extends TileMultipart
implements IEnergyHandler {
    public Set<PartConductor> teConductorInterfaces = new HashSet<PartConductor>();
    public Set<IEnergyHandler> teInterfaces = new HashSet<IEnergyHandler>();

    public void copyFrom(TileMultipart that) {
        super.copyFrom(that);
        if (that instanceof TraitEnergyHandler) {
            this.teConductorInterfaces = ((TraitEnergyHandler)that).teConductorInterfaces;
            this.teInterfaces = ((TraitEnergyHandler)that).teInterfaces;
        }
    }

    public void bindPart(TMultiPart part) {
        super.bindPart(part);
        if (part instanceof IEnergyHandler) {
            if (part instanceof PartConductor) {
                this.teConductorInterfaces.add((PartConductor)part);
            } else {
                this.teInterfaces.add((IEnergyHandler)part);
            }
        }
    }

    public void partRemoved(TMultiPart part, int p) {
        super.partRemoved(part, p);
        if (part instanceof IEnergyHandler) {
            if (part instanceof PartConductor) {
                this.teConductorInterfaces.remove(part);
            } else {
                this.teInterfaces.remove(part);
            }
        }
    }

    public void clearParts() {
        super.clearParts();
        this.teInterfaces.clear();
        this.teConductorInterfaces.clear();
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        Iterator<IEnergyHandler> i$;
        if (this.partMap(from.ordinal()) == null) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TMultiPart part;
                if (dir == from.getOpposite() || !this.teConductorInterfaces.contains(part = this.partMap(dir.ordinal()))) continue;
                return ((IEnergyHandler)part).receiveEnergy(from, maxReceive, simulate);
            }
        }
        if ((i$ = this.teInterfaces.iterator()).hasNext()) {
            IEnergyHandler handler = i$.next();
            return handler.receiveEnergy(from, maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canInterface(ForgeDirection from) {
        Iterator<IEnergyHandler> i$;
        if (this.partMap(from.ordinal()) == null) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TMultiPart part;
                if (dir == from.getOpposite() || !this.teConductorInterfaces.contains(part = this.partMap(dir.ordinal()))) continue;
                return ((IEnergyHandler)part).canInterface(from);
            }
        }
        if ((i$ = this.teInterfaces.iterator()).hasNext()) {
            IEnergyHandler handler = i$.next();
            return handler.canInterface(from);
        }
        return false;
    }

    public int getEnergyStored(ForgeDirection from) {
        Iterator<IEnergyHandler> i$;
        if (this.partMap(from.ordinal()) == null) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TMultiPart part;
                if (dir == from.getOpposite() || !this.teConductorInterfaces.contains(part = this.partMap(dir.ordinal()))) continue;
                return ((IEnergyHandler)part).getEnergyStored(from);
            }
        }
        if ((i$ = this.teInterfaces.iterator()).hasNext()) {
            IEnergyHandler handler = i$.next();
            return handler.getEnergyStored(from);
        }
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        Iterator<IEnergyHandler> i$;
        if (this.partMap(from.ordinal()) == null) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TMultiPart part;
                if (dir == from.getOpposite() || !this.teConductorInterfaces.contains(part = this.partMap(dir.ordinal()))) continue;
                return ((IEnergyHandler)part).getMaxEnergyStored(from);
            }
        }
        if ((i$ = this.teInterfaces.iterator()).hasNext()) {
            IEnergyHandler handler = i$.next();
            return handler.getMaxEnergyStored(from);
        }
        return 0;
    }
}

