/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.electrical.wire.trait;

import codechicken.multipart.PartMap;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import ic2.api.energy.tile.IEnergySink;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TraitEnergySink
extends TileMultipart
implements IEnergySink {
    public Set<IEnergySink> icInterfaces = new HashSet<IEnergySink>();

    public void copyFrom(TileMultipart that) {
        super.copyFrom(that);
        if (that instanceof TraitEnergySink) {
            this.icInterfaces = ((TraitEnergySink)that).icInterfaces;
        }
    }

    public void bindPart(TMultiPart part) {
        super.bindPart(part);
        if (part instanceof IEnergySink) {
            this.icInterfaces.add((IEnergySink)part);
        }
    }

    public void partRemoved(TMultiPart part, int p) {
        super.partRemoved(part, p);
        if (part instanceof IEnergySink) {
            this.icInterfaces.remove(part);
        }
    }

    public void clearParts() {
        super.clearParts();
        this.icInterfaces.clear();
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection from) {
        if (this.partMap(from.ordinal()) == null) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TMultiPart part;
                if (dir == from.getOpposite() || !this.icInterfaces.contains(part = this.partMap(dir.ordinal()))) continue;
                return ((IEnergySink)part).acceptsEnergyFrom(emitter, from);
            }
        }
        return false;
    }

    public double demandedEnergyUnits() {
        double demanded = 0.0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TMultiPart part = this.partMap(dir.ordinal());
            if (!(part instanceof IEnergySink)) continue;
            demanded += ((IEnergySink)part).demandedEnergyUnits();
        }
        return demanded;
    }

    public double injectEnergyUnits(ForgeDirection from, double amount) {
        if (this.partMap(from.ordinal()) instanceof IEnergySink) {
            return ((IEnergySink)this.partMap(from.ordinal())).injectEnergyUnits(from, amount);
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TMultiPart part;
            if (dir == from.getOpposite() || !((part = this.partMap(dir.ordinal())) instanceof IEnergySink)) continue;
            return ((IEnergySink)part).injectEnergyUnits(from, amount);
        }
        if (this.partMap(PartMap.CENTER.ordinal()) instanceof IEnergySink) {
            return ((IEnergySink)this.partMap(PartMap.CENTER.ordinal())).injectEnergyUnits(from, amount);
        }
        return amount;
    }

    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }
}

