/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.block;

import enhancedcore.util.MathHelper;
import enhancedportals.lib.Localization;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockEnhancedPortals
extends BlockContainer {
    private boolean canRotate = false;
    private boolean canRotateVertically = false;

    protected BlockEnhancedPortals(int id, Material material) {
        super(id, material);
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public String func_71931_t() {
        return Localization.localizeString(this.func_71917_a() + ".name");
    }

    private ForgeDirection getNextRotation(World worldObj, int x, int y, int z) {
        if (this.canRotate) {
            ForgeDirection[] validRotations = this.getValidRotations(worldObj, x, y, z);
            ForgeDirection currentRotation = ForgeDirection.getOrientation((int)worldObj.func_72805_g(x, y, z));
            if (validRotations == null) {
                return null;
            }
            for (int i = 0; i < validRotations.length; ++i) {
                if (validRotations[i] != currentRotation) continue;
                if (i + 1 < validRotations.length) {
                    return validRotations[i + 1];
                }
                return validRotations[0];
            }
        }
        return null;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return null;
    }

    public boolean func_71903_a(World worldObj, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (this.canRotate && player.func_70093_af()) {
            ForgeDirection nextRotation = this.getNextRotation(worldObj, x, y, z);
            if (nextRotation == null || player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] != null) {
                return false;
            }
            this.rotateBlock(worldObj, x, y, z, nextRotation);
        }
        return false;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (this.canRotate) {
            int direction = 0;
            int facing = MathHelper.floorDouble((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            if (facing == 0) {
                direction = ForgeDirection.NORTH.ordinal();
            } else if (facing == 1) {
                direction = ForgeDirection.EAST.ordinal();
            } else if (facing == 2) {
                direction = ForgeDirection.SOUTH.ordinal();
            } else if (facing == 3) {
                direction = ForgeDirection.WEST.ordinal();
            }
            if (this.canRotateVertically) {
                if (entityLivingBase.field_70125_A > 65.0f && entityLivingBase.field_70125_A <= 90.0f) {
                    direction = ForgeDirection.UP.ordinal();
                } else if (entityLivingBase.field_70125_A < -65.0f && entityLivingBase.field_70125_A >= -90.0f) {
                    direction = ForgeDirection.DOWN.ordinal();
                }
            }
            world.func_72921_c(x, y, z, direction, 0);
        }
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        if (this.canRotate) {
            worldObj.func_72921_c(x, y, z, axis.ordinal(), 2);
        }
        return true;
    }

    public void setCanRotate() {
        this.canRotate = true;
    }

    public void setCanRotateVertically() {
        this.canRotateVertically = true;
    }
}

