/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.block;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enhancedcore.util.MathHelper;
import enhancedportals.EnhancedPortals;
import enhancedportals.block.BlockEnhancedPortals;
import enhancedportals.client.particle.NetherPortalFX;
import enhancedportals.lib.BlockIds;
import enhancedportals.lib.Settings;
import enhancedportals.portal.Portal;
import enhancedportals.tileentity.TileEntityNetherPortal;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockNetherPortal
extends BlockEnhancedPortals {
    public BlockNetherPortal() {
        super(BlockIds.NetherPortal, Material.field_76237_B);
        this.func_71848_c(-1.0f);
        this.func_71884_a(field_71974_j);
        this.func_71900_a(0.75f);
        this.func_71864_b("portal");
        this.func_71907_b(true);
    }

    @Override
    public TileEntity func_72274_a(World world) {
        return new TileEntityNetherPortal();
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return EnhancedPortals.proxy.blockDummyPortal.func_71858_a(side, meta);
    }

    public int func_71857_b() {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71922_a(World par1World, int par2, int par3, int par4) {
        return 0;
    }

    public boolean func_71926_d() {
        return false;
    }

    @Override
    public boolean func_71903_a(World worldObj, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        return new Portal(x, y, z, worldObj).handleBlockActivation(player);
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        new Portal(x, y, z, world).handleEntityCollide(entity);
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        new Portal(x, y, z, world).handleNeighborChange(id);
    }

    public int func_71925_a(Random par1Random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random random) {
        Portal portal = new Portal(x, y, z, world);
        if (random.nextInt(100) < Settings.SoundLevel - 1 && random.nextInt(100) == 0 && portal.producesSound) {
            world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "portal.portal", 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        if (random.nextInt(100) < Settings.ParticleLevel - 1) {
            for (int i = 0; i < 4; ++i) {
                double d0 = (float)x + random.nextFloat();
                double d1 = (float)y + random.nextFloat();
                double d2 = (float)z + random.nextFloat();
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                int i1 = random.nextInt(2) * 2 - 1;
                d3 = ((double)random.nextFloat() - 0.5) * 0.5;
                d4 = ((double)random.nextFloat() - 0.5) * 0.5;
                d5 = ((double)random.nextFloat() - 0.5) * 0.5;
                if (world.func_72798_a(x - 1, y, z) != this.field_71990_ca && world.func_72798_a(x + 1, y, z) != this.field_71990_ca) {
                    d0 = (double)x + 0.5 + 0.25 * (double)i1;
                    d3 = random.nextFloat() * 2.0f * (float)i1;
                } else {
                    d2 = (double)z + 0.5 + 0.25 * (double)i1;
                    d5 = random.nextFloat() * 2.0f * (float)i1;
                }
                if (Settings.AllowPortalColours && portal.producesParticles) {
                    if (portal.texture.equals("I:" + Item.field_82792_bS.field_77779_bT + ":0")) continue;
                    FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new NetherPortalFX(world, portal.texture, d0, d1, d2, d3, d4, d5));
                    continue;
                }
                if (Settings.AllowPortalColours || !portal.producesParticles) continue;
                world.func_72869_a("portal", d0, d1, d2, d3, d4, d5);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
    }

    public boolean func_71886_c() {
        return false;
    }

    public void func_71902_a(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntityNetherPortal portal = (TileEntityNetherPortal)blockAccess.func_72796_p(x, y, z);
        int meta = blockAccess.func_72805_g(x, y, z);
        float thick = 0.125f * (float)portal.thickness;
        float thickA = MathHelper.clampFloat((float)(0.375f - thick), (float)0.0f, (float)1.0f);
        float thickB = MathHelper.clampFloat((float)(0.625f + thick), (float)0.0f, (float)1.0f);
        if (portal.texture.equals("I:" + Item.field_82792_bS.field_77779_bT + ":0")) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (meta == 2 || meta == 3) {
            this.func_71905_a(0.0f, 0.0f, thickA, 1.0f, 1.0f, thickB);
        } else if (meta == 4 || meta == 5) {
            this.func_71905_a(thickA, 0.0f, 0.0f, thickB, 1.0f, 1.0f);
        } else if (meta == 6 || meta == 7) {
            this.func_71905_a(0.0f, thickA, 0.0f, 1.0f, thickB, 1.0f);
        }
    }

    public boolean tryToCreatePortal(World world, int x, int y, int z) {
        return new Portal(x, y, z, world).createPortal();
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        super.func_71847_b(world, y, x, z, random);
        if (random.nextInt(100) < Settings.PigmenLevel - 1 && random.nextInt(2000) < world.field_73013_u) {
            Entity zombiePigman;
            int y2;
            for (y2 = y; !world.func_72797_t(x, y2, z) && y2 > 0; --y2) {
            }
            if (y2 > 0 && world.func_72809_s(x, y2 + 1, z) && (zombiePigman = ItemMonsterPlacer.func_77840_a((World)world, (int)57, (double)((double)x + 0.5), (double)((double)y2 + 1.1), (double)((double)z + 0.5))) != null) {
                zombiePigman.field_71088_bW = zombiePigman.func_82147_ab();
            }
        }
    }
}

