/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.common;

import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import mods.neiplugins.lists.RecipeHandlerListElement;
import net.minecraft.item.ItemStack;

public abstract class RecipeHandlerUtils {
    public static Map<String, ArrayList<RecipeHandlerListElement>> recipeListMap = new TreeMap<String, ArrayList<RecipeHandlerListElement>>();

    public static boolean addToRecipeList(String mod, String recipeType, int type, String id, Object ... params) {
        return RecipeHandlerUtils.addToRecipeList(mod, null, recipeType, type, id, params);
    }

    public static boolean addToRecipeList(String mod, ItemStack icon, String recipeType, int type, String id, Object ... params) {
        if (!recipeListMap.containsKey(mod)) {
            recipeListMap.put(mod, new ArrayList());
        }
        for (RecipeHandlerListElement element : recipeListMap.get(mod)) {
            if (!element.id.equals(id)) continue;
            return false;
        }
        recipeListMap.get(mod).add(new RecipeHandlerListElement(recipeType, icon, type, id, params));
        return true;
    }

    public static boolean removeRecipeHandler(Class cls) {
        ICraftingHandler craftingHandler = null;
        for (ICraftingHandler handler : GuiCraftingRecipe.craftinghandlers) {
            if (handler.getClass() != cls) continue;
            craftingHandler = handler;
        }
        IUsageHandler usageHandler = null;
        for (IUsageHandler handler : GuiUsageRecipe.usagehandlers) {
            if (handler.getClass() != cls) continue;
            usageHandler = handler;
        }
        if (craftingHandler != null) {
            GuiCraftingRecipe.craftinghandlers.remove(craftingHandler);
        }
        if (usageHandler != null) {
            GuiUsageRecipe.usagehandlers.remove(usageHandler);
        }
        return craftingHandler != null || usageHandler != null;
    }
}

