/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.gregtech;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import gregtechmod.api.util.GT_ModHandler;
import gregtechmod.api.util.GT_PulverizerRecipe;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import mods.neiplugins.common.PositionedStackWithTooltip;
import mods.neiplugins.common.Utils;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class PulverizerRecipeHandler
extends LiquidTemplateRecipeHandler {
    private static Map sPulverizerRecipes;

    public String getRecipeName() {
        return "Universal Macerator";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)40);
        GuiDraw.drawTexturedModalRect((int)102, (int)13, (int)8, (int)83, (int)35, (int)18);
    }

    public void drawExtras(int recipe) {
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(66, 20, 36, 18), this.getRecipeId(), new Object[0]));
    }

    @Override
    public String getRecipeId() {
        return "gregtech.m_pulverizer";
    }

    public Collection getRecipes() {
        sPulverizerRecipes = (Map)Utils.getField(GT_ModHandler.class, "sPulverizerRecipes", null);
        if (sPulverizerRecipes == null) {
            sPulverizerRecipes = new HashMap();
        }
        return sPulverizerRecipes.values();
    }

    @Override
    public void loadSameRecipeId() {
        for (Object irecipe : this.getRecipes()) {
            if (!(irecipe instanceof GT_PulverizerRecipe)) continue;
            this.arecipes.add(new CachedPulverizerRecipe((GT_PulverizerRecipe)irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Object irecipe : this.getRecipes()) {
            GT_PulverizerRecipe recipe;
            if (!(irecipe instanceof GT_PulverizerRecipe) || !NEIClientUtils.areStacksSameTypeCrafting((ItemStack)(recipe = (GT_PulverizerRecipe)irecipe).getPrimaryOutput(), (ItemStack)result) && !NEIClientUtils.areStacksSameTypeCrafting((ItemStack)recipe.getSecondaryOutput(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedPulverizerRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object irecipe : this.getRecipes()) {
            GT_PulverizerRecipe recipe;
            if (!(irecipe instanceof GT_PulverizerRecipe) || !NEIClientUtils.areStacksSameTypeCrafting((ItemStack)(recipe = (GT_PulverizerRecipe)irecipe).getInput(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedPulverizerRecipe(recipe));
        }
    }

    public String getGuiTexture() {
        return "gregtech_addon:textures/gui/Macerator.png";
    }

    public class CachedPulverizerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack primaryOutput;
        PositionedStack secondaryOutput;
        ArrayList<PositionedStack> ingredients;

        public CachedPulverizerRecipe(GT_PulverizerRecipe recipe) {
            super((TemplateRecipeHandler)PulverizerRecipeHandler.this);
            this.ingredients = new ArrayList();
            if (recipe.getInput() != null) {
                this.ingredients.add(new PositionedStack((Object)recipe.getInput(), 48, 14));
            }
            this.secondaryOutput = null;
            if (recipe.getPrimaryOutput() != null) {
                this.primaryOutput = new PositionedStack((Object)recipe.getPrimaryOutput(), 102, 14);
            }
            if (recipe.getSecondaryOutput() != null) {
                PositionedStackWithTooltip pStack = new PositionedStackWithTooltip(recipe.getSecondaryOutput(), 120, 14);
                pStack.setIntegerChanceTooltip(recipe.getSecondaryOutputChance());
                this.secondaryOutput = pStack;
            }
        }

        public PositionedStack getOtherStack() {
            return this.secondaryOutput;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(PulverizerRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.primaryOutput;
        }
    }
}

