/*
 * Decompiled with CFR 0.152.
 */
package openmods.config;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatMessageComponent;
import openmods.Log;
import openmods.config.ConfigProcessing;
import openmods.config.ConfigPropertyMeta;
import openmods.utils.io.StringConversionException;
import org.apache.commons.lang3.ArrayUtils;

public class CommandConfig
implements ICommand {
    private static final String COMMAND_REMOVE = "remove";
    private static final String COMMAND_APPEND = "append";
    private static final String COMMAND_SET = "set";
    private static final String COMMAND_CLEAR = "clear";
    private static final String COMMAND_GET = "get";
    private static final String COMMAND_HELP = "help";
    private static final String COMMAND_SAVE = "save";
    private static final Set<String> SUBCOMMANDS = ImmutableSet.of((Object)"save", (Object)"help", (Object)"get", (Object)"clear", (Object)"set", (Object)"append", (Object[])new String[]{"remove"});
    private final String name;
    private final boolean restricted;

    public CommandConfig(String name, boolean restricted) {
        this.name = name;
        this.restricted = restricted;
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((ICommand)o).func_71517_b());
    }

    public String func_71517_b() {
        return this.name;
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return this.name + " save <modid> OR\n" + this.name + " help <modid> <category> <name> OR\n" + this.name + " get <modid> <category> <name> OR\n" + this.name + " clear <modid> <category> <name> OR\n" + this.name + " set <modid> <category> <name> <value>... OR\n" + this.name + " append <modid> <category> <name> <value>... OR\n" + this.name + " remove <modid> <category> <name> <value>...";
    }

    public List func_71514_a() {
        return null;
    }

    private static void respond(ICommandSender sender, String format) {
        sender.func_70006_a(ChatMessageComponent.func_111077_e((String)format));
    }

    private static void respond(ICommandSender sender, String format, Object ... args) {
        sender.func_70006_a(ChatMessageComponent.func_111082_b((String)format, (Object[])args));
    }

    private static void printValue(ICommandSender sender, ConfigProcessing.ModConfig config, ConfigPropertyMeta property) {
        CommandConfig.respond(sender, "%s.%s.%s = %s (%s)", config.modId, property.category, property.name, property.valueDescription(), property.type.toString());
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            CommandConfig.respond(sender, "openmodslib.command.no_enough_args");
            return;
        }
        String command = args[0];
        if (!SUBCOMMANDS.contains(command)) {
            CommandConfig.respond(sender, "openmodslib.command.invalid_command", command);
            return;
        }
        String modId = args[1];
        ConfigProcessing.ModConfig config = ConfigProcessing.getConfig(modId);
        if (config == null) {
            CommandConfig.respond(sender, "openmodslib.command.unknown_modid");
            return;
        }
        if (COMMAND_SAVE.equals(command)) {
            config.save();
            CommandConfig.respond(sender, "openmodslib.command.saved", config.configFile.getAbsolutePath());
            return;
        }
        if (args.length < 4) {
            CommandConfig.respond(sender, "openmodslib.command.no_enough_args");
            return;
        }
        String category = args[2];
        String name = args[3];
        ConfigPropertyMeta property = config.getValue(category, name);
        if (property == null) {
            CommandConfig.respond(sender, "openmodslib.command.unknown_value");
            return;
        }
        if (COMMAND_HELP.equals(command)) {
            CommandConfig.respond(sender, "%s.%s.%s: %s (%s)", config.modId, property.category, property.name, property.comment, property.type.toString());
            return;
        }
        if (COMMAND_GET.equals(command)) {
            CommandConfig.printValue(sender, config, property);
            return;
        }
        if (COMMAND_CLEAR.equals(command)) {
            if (property.acceptsMultipleValues()) {
                this.changeValue(config, sender, property, new String[0]);
            } else {
                CommandConfig.respond(sender, "openmodslib.command.not_multiple");
            }
            return;
        }
        if (args.length < 5) {
            CommandConfig.respond(sender, "openmodslib.command.no_enough_args");
            return;
        }
        Object[] values = Arrays.copyOfRange(args, 4, args.length);
        if (COMMAND_SET.equals(command)) {
            this.changeValue(config, sender, property, (String[])values);
            return;
        }
        if (!property.acceptsMultipleValues()) {
            CommandConfig.respond(sender, "openmodslib.command.not_multiple");
            return;
        }
        Object[] current = property.getPropertyValue();
        if (COMMAND_APPEND.equals(command)) {
            this.changeValue(config, sender, property, (String[])ArrayUtils.addAll((Object[])current, (Object[])values));
            return;
        }
        if (COMMAND_REMOVE.equals(command)) {
            this.changeValue(config, sender, property, (String[])ArrayUtils.removeElements((Object[])current, (Object[])values));
            return;
        }
        CommandConfig.respond(sender, "openmodslib.command.no_enough_args");
    }

    protected void changeValue(ConfigProcessing.ModConfig config, ICommandSender sender, ConfigPropertyMeta property, String ... values) {
        try {
            ConfigPropertyMeta.Result changeResult = property.tryChangeValue(values);
            switch (changeResult) {
                case ONLINE: {
                    CommandConfig.respond(sender, "openmodslib.command.online_change");
                    break;
                }
                case OFFLINE: {
                    CommandConfig.respond(sender, "openmodslib.command.offline_change");
                    break;
                }
                default: {
                    CommandConfig.respond(sender, "openmodslib.command.cancelled");
                }
            }
            CommandConfig.printValue(sender, config, property);
        }
        catch (StringConversionException e) {
            CommandConfig.respond(sender, "openmodslib.command.invalid_type", Arrays.toString(values), property.type);
        }
        catch (Exception e) {
            CommandConfig.respond(sender, "openmodslib.command.unknown_error", e.getMessage());
            Log.warn(e, "Error during command change", new Object[0]);
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        int level = this.restricted ? 4 : 0;
        return sender.func_70003_b(level, this.name);
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        String command = args[0];
        if (args.length == 1) {
            return CommandConfig.filterPrefixes(command, SUBCOMMANDS);
        }
        String modId = args[1];
        if (args.length == 2) {
            return CommandConfig.filterPrefixes(modId, ConfigProcessing.getConfigsIds());
        }
        if (COMMAND_SAVE.equals(command)) {
            return null;
        }
        ConfigProcessing.ModConfig config = ConfigProcessing.getConfig(modId);
        if (config == null) {
            return null;
        }
        String category = args[2];
        if (args.length == 3) {
            return CommandConfig.filterPrefixes(category, config.getCategories());
        }
        String name = args[3];
        if (args.length == 4) {
            return CommandConfig.filterPrefixes(name, config.getValues(category));
        }
        return null;
    }

    private static List<String> filterPrefixes(String prefix, Collection<String> proposals) {
        prefix = prefix.toLowerCase();
        ArrayList result = Lists.newArrayList();
        for (String s : proposals) {
            if (!s.startsWith(prefix)) continue;
            result.add(s);
        }
        return result;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }
}

