/*
 * Decompiled with CFR 0.152.
 */
package openmods.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import openmods.Log;
import openmods.config.BlockId;
import openmods.config.ConfigPropertyMeta;
import openmods.config.IRegisterableBlock;
import openmods.config.ItemId;
import openmods.config.RegisterBlock;
import openmods.config.RegisterFluid;
import openmods.config.RegisterItem;

public class ConfigProcessing {
    private static final Map<String, ModConfig> configs = Maps.newHashMap();

    public static Collection<String> getConfigsIds() {
        return Collections.unmodifiableCollection(configs.keySet());
    }

    public static ModConfig getConfig(String modId) {
        return configs.get(modId.toLowerCase());
    }

    private static void getBlock(Configuration configFile, Field field, String description) {
        try {
            int defaultValue = field.getInt(null);
            Property prop = configFile.getBlock("block", field.getName(), defaultValue, description);
            field.set(null, prop.getInt());
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void getItem(Configuration configFile, Field field, String description) {
        try {
            int defaultValue = field.getInt(null);
            Property prop = configFile.getItem("item", field.getName(), defaultValue, description);
            field.set(null, prop.getInt());
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static boolean canRegisterBlock(int blockId) {
        if (blockId > 0) {
            Preconditions.checkState((Block.field_71973_m[blockId] == null ? 1 : 0) != 0, (String)"OpenBlocks tried to register a block for ID: %s but it was in use", (Object[])new Object[]{blockId});
            return true;
        }
        return false;
    }

    public static void processAnnotations(File configFile, String modId, Configuration config, Class<?> klazz) {
        Preconditions.checkState((!configs.containsKey(modId) ? 1 : 0) != 0, (String)"Trying to configure mod '%s' twice", (Object[])new Object[]{modId});
        ModConfig configMeta = new ModConfig(modId, configFile, config, klazz);
        configs.put(modId.toLowerCase(), configMeta);
        for (Field f : klazz.getFields()) {
            Annotation a = f.getAnnotation(ItemId.class);
            if (a != null) {
                ConfigProcessing.getItem(config, f, a.description());
                continue;
            }
            a = f.getAnnotation(BlockId.class);
            if (a != null) {
                ConfigProcessing.getBlock(config, f, a.description());
            }
            configMeta.tryProcessConfig(f);
        }
    }

    public static <I, A extends Annotation> void processAnnotations(Class<?> config, Class<I> fieldClass, Class<A> annotationClass, IAnnotationProcessor<I, A> processor) {
        for (Field f : config.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !fieldClass.isAssignableFrom(f.getType())) continue;
            A annotation = f.getAnnotation(annotationClass);
            if (annotation != null) {
                try {
                    Object entry = f.get(null);
                    if (entry == null) continue;
                    processor.process(entry, annotation);
                    continue;
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            Log.warn("Field %s has valid type %s for registration, but no annotation %s", f, fieldClass, annotationClass);
        }
    }

    private static String dotName(String a, String b) {
        return a + "." + b;
    }

    private static String underscoreName(String a, String b) {
        return a + "_" + b;
    }

    public static void registerItems(Class<?> klazz, final String mod) {
        ConfigProcessing.processAnnotations(klazz, Item.class, RegisterItem.class, new IAnnotationProcessor<Item, RegisterItem>(){

            @Override
            public void process(Item item, RegisterItem annotation) {
                String name = ConfigProcessing.dotName(mod, annotation.name());
                GameRegistry.registerItem((Item)item, (String)name);
                String unlocalizedName = annotation.unlocalizedName();
                if (!unlocalizedName.equals("[none]")) {
                    unlocalizedName = unlocalizedName.equals("[default]") ? name : ConfigProcessing.dotName(mod, unlocalizedName);
                    item.func_77655_b(unlocalizedName);
                }
            }
        });
    }

    public static void registerBlocks(Class<?> klazz, final String mod) {
        ConfigProcessing.processAnnotations(klazz, Block.class, RegisterBlock.class, new IAnnotationProcessor<Block, RegisterBlock>(){

            @Override
            public void process(Block block, RegisterBlock annotation) {
                String name = annotation.name();
                Class<? extends ItemBlock> itemBlock = annotation.itemBlock();
                Class<? extends TileEntity> teClass = annotation.tileEntity();
                if (teClass == TileEntity.class) {
                    teClass = null;
                }
                String blockName = ConfigProcessing.underscoreName(mod, name);
                GameRegistry.registerBlock((Block)block, itemBlock, (String)blockName);
                String unlocalizedName = annotation.unlocalizedName();
                if (!unlocalizedName.equals("[none]")) {
                    unlocalizedName = unlocalizedName.equals("[default]") ? ConfigProcessing.dotName(mod, name) : ConfigProcessing.dotName(mod, unlocalizedName);
                    block.func_71864_b(unlocalizedName);
                }
                if (teClass != null) {
                    GameRegistry.registerTileEntity(teClass, (String)blockName);
                }
                if (block instanceof IRegisterableBlock) {
                    ((IRegisterableBlock)block).setupBlock(mod, name, teClass, itemBlock);
                }
                for (RegisterBlock.RegisterTileEntity te : annotation.tileEntities()) {
                    String teName = ConfigProcessing.underscoreName(mod, te.name());
                    GameRegistry.registerTileEntity(te.cls(), (String)teName);
                }
            }
        });
    }

    public static void registerFluids(Class<?> klazz, final String mod) {
        ConfigProcessing.processAnnotations(klazz, Fluid.class, RegisterFluid.class, new IAnnotationProcessor<Fluid, RegisterFluid>(){

            @Override
            public void process(Fluid fluid, RegisterFluid annotation) {
                fluid.setDensity(annotation.density());
                fluid.setGaseous(annotation.gaseous());
                fluid.setLuminosity(annotation.luminosity());
                fluid.setViscosity(annotation.viscosity());
                FluidRegistry.registerFluid((Fluid)fluid);
                fluid.setUnlocalizedName(String.format("%s.%s", mod, annotation.name()));
            }
        });
    }

    private static interface IAnnotationProcessor<I, A extends Annotation> {
        public void process(I var1, A var2);
    }

    public static class ModConfig {
        private final Configuration config;
        public final Class<?> configClass;
        public final File configFile;
        public final String modId;
        private Table<String, String, ConfigPropertyMeta> properties = HashBasedTable.create();

        private ModConfig(String modId, File configFile, Configuration config, Class<?> configClass) {
            this.modId = modId;
            this.configFile = configFile;
            this.config = config;
            this.configClass = configClass;
        }

        void tryProcessConfig(Field field) {
            ConfigPropertyMeta meta = ConfigPropertyMeta.createMetaForField(this.config, field);
            if (meta != null) {
                meta.updateValueFromConfig(false);
                this.properties.put((Object)meta.category.toLowerCase(), (Object)meta.name.toLowerCase(), (Object)meta);
            }
        }

        public void save() {
            if (this.config.hasChanged()) {
                this.config.save();
            }
        }

        public Collection<String> getCategories() {
            return Collections.unmodifiableCollection(this.properties.rowKeySet());
        }

        public Collection<String> getValues(String category) {
            return Collections.unmodifiableCollection(this.properties.row((Object)category.toLowerCase()).keySet());
        }

        public ConfigPropertyMeta getValue(String category, String name) {
            return (ConfigPropertyMeta)this.properties.get((Object)category.toLowerCase(), (Object)name.toLowerCase());
        }
    }
}

