/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import openmods.Log;
import openmods.integration.Integration;
import openmods.proxy.IOpenModsProxy;
import openmods.sync.SyncableFlags;
import openmods.utils.BlockUtils;

public class GenericTank
extends FluidTank {
    protected List<ForgeDirection> surroundingTanks = new ArrayList<ForgeDirection>();
    protected FluidStack[] acceptableFluids;

    public GenericTank(int capacity, FluidStack ... acceptableFluids) {
        super(capacity);
        this.acceptableFluids = acceptableFluids;
    }

    public void refreshSurroundingTanks(TileEntity currentTile, SyncableFlags sides) {
        HashSet<ForgeDirection> checkSides = new HashSet<ForgeDirection>();
        if (sides == null) {
            checkSides.addAll(Arrays.asList(ForgeDirection.VALID_DIRECTIONS));
        } else {
            for (Integer s : sides.getActiveSlots()) {
                checkSides.add(ForgeDirection.getOrientation((int)s));
            }
        }
        this.surroundingTanks = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : checkSides) {
            TileEntity tile = BlockUtils.getTileInDirection(currentTile, side);
            if (!(tile instanceof IFluidHandler)) continue;
            this.surroundingTanks.add(side);
        }
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (this.fluid == null) {
            return null;
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public int getSpace() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public double getPercentFull() {
        return (double)this.getFluidAmount() / (double)this.getCapacity();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.acceptableFluids.length == 0) {
            return super.fill(resource, doFill);
        }
        for (FluidStack acceptableFluid : this.acceptableFluids) {
            if (!acceptableFluid.isFluidEqual(resource)) continue;
            return super.fill(resource, doFill);
        }
        return 0;
    }

    public void autoOutputToSides(IOpenModsProxy proxy, int amountPerTick, TileEntity currentTile, SyncableFlags sides) {
        FluidStack drainedFluid;
        if (currentTile.field_70331_k == null) {
            return;
        }
        if (proxy.getTicks(currentTile.field_70331_k) % 10L == 0L) {
            this.refreshSurroundingTanks(currentTile, sides);
        }
        if (this.getFluidAmount() > 0 && this.surroundingTanks.size() > 0 && (drainedFluid = this.drain(Math.min(this.getFluidAmount(), amountPerTick), true)) != null) {
            Collections.shuffle(this.surroundingTanks);
            for (ForgeDirection side : this.surroundingTanks) {
                TileEntity otherTank = BlockUtils.getTileInDirection(currentTile, side);
                if (drainedFluid.amount <= 0) continue;
                drainedFluid = drainedFluid.copy();
                if (otherTank instanceof IFluidHandler) {
                    drainedFluid.amount -= ((IFluidHandler)otherTank).fill(side.getOpposite(), drainedFluid, true);
                    continue;
                }
                drainedFluid.amount -= Integration.modBuildCraft().tryAcceptIntoPipe(otherTank, drainedFluid, side.getOpposite());
            }
            if (drainedFluid.amount > 0) {
                this.fill(drainedFluid, true);
            }
        }
    }

    public void autoFillFromSides(IOpenModsProxy proxy, int amountPerTick, TileEntity currentTile) {
        this.autoFillFromSides(proxy, amountPerTick, currentTile, null);
    }

    public void autoFillFromSides(IOpenModsProxy proxy, int amountPerTick, TileEntity currentTile, SyncableFlags sides) {
        if (proxy.getTicks(currentTile.field_70331_k) % 10L == 0L) {
            this.refreshSurroundingTanks(currentTile, sides);
        }
        if (this.getSpace() > 0 && this.surroundingTanks.size() > 0) {
            Collections.shuffle(this.surroundingTanks);
            for (ForgeDirection side : this.surroundingTanks) {
                TileEntity otherTank = BlockUtils.getTileInDirection(currentTile, side);
                if (!(otherTank instanceof IFluidHandler)) continue;
                IFluidHandler handler = (IFluidHandler)otherTank;
                FluidStack currentFluid = this.getFluid();
                if (currentFluid == null) {
                    FluidTankInfo[] infos = handler.getTankInfo(side.getOpposite());
                    if (infos == null) {
                        Log.fine("Tank %s @ (%d,%d,%d) returned null tank info. Nasty.", otherTank.getClass(), otherTank.field_70329_l, otherTank.field_70330_m, otherTank.field_70327_n);
                        continue;
                    }
                    for (FluidTankInfo info : infos) {
                        if (this.acceptableFluids.length == 0 && info.fluid != null) {
                            currentFluid = info.fluid;
                        } else {
                            for (FluidStack acceptFluid : this.acceptableFluids) {
                                if (info.fluid == null || !info.fluid.isFluidEqual(acceptFluid)) continue;
                                currentFluid = info.fluid;
                                break;
                            }
                        }
                        if (currentFluid != null) break;
                    }
                }
                if (currentFluid == null) continue;
                FluidStack drainStack = currentFluid.copy();
                drainStack.amount = Math.min(amountPerTick, this.getSpace());
                FluidStack drained = handler.drain(side.getOpposite(), drainStack, true);
                this.fill(drained, true);
                if (this.getCapacity() != this.getFluidAmount()) continue;
                break;
            }
        }
    }
}

