/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import openmods.utils.ByteUtils;

public class CollectionUtils {
    public static final Random rnd = new Random();

    public static <T> T getRandom(Collection<T> collection) {
        if (collection.size() == 0) {
            return null;
        }
        int randomIndex = rnd.nextInt(collection.size());
        int i = 0;
        for (T obj : collection) {
            if (i == randomIndex) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    public static <T> T getWeightedRandom(Map<T, Integer> collection) {
        int totalWeight = 0;
        Collection<Integer> values = collection.values();
        for (Integer i : values) {
            totalWeight += i.intValue();
        }
        int r = rnd.nextInt(totalWeight);
        for (Map.Entry<T, Integer> entry : collection.entrySet()) {
            if ((r -= entry.getValue().intValue()) > 0) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void readSortedIdList(DataInput input, Collection<Integer> output) {
        int elemCount = ByteUtils.readVLI(input);
        int currentId = 0;
        for (int i = 0; i < elemCount; ++i) {
            output.add(currentId += ByteUtils.readVLI(input));
        }
    }

    public static void writeSortedIdList(DataOutput output, SortedSet<Integer> idList) {
        ByteUtils.writeVLI(output, idList.size());
        int currentId = 0;
        for (Integer id : idList) {
            int delta = id - currentId;
            ByteUtils.writeVLI(output, delta);
            currentId = id;
        }
    }
}

