/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import net.minecraft.entity.Entity;
import openmods.utils.Coord;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class MathUtils {
    public static final double lengthSq(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static final double lengthSq(double x, double z) {
        return x * x + z * z;
    }

    public static Matrix4f createEntityRotateMatrix(Entity entity) {
        double yaw = Math.toRadians(entity.field_70177_z - 180.0f);
        double pitch = Math.toRadians(entity.field_70125_A);
        Matrix4f initial = new Matrix4f();
        initial.rotate((float)pitch, new Vector3f(1.0f, 0.0f, 0.0f));
        initial.rotate((float)yaw, new Vector3f(0.0f, 1.0f, 0.0f));
        return initial;
    }

    public static int getSphericalDistance(Coord startPos, Coord endPos) {
        int dx = endPos.x - startPos.x;
        int dy = endPos.z - startPos.z;
        int dz = endPos.y - startPos.y;
        return (int)Math.round(Math.sqrt(dx * dx + dy * dy + dz * dz));
    }

    public static int getCubicDistance(Coord startPos, Coord endPos) {
        return Math.abs(endPos.x - startPos.x) + Math.abs(endPos.y - startPos.y) + Math.abs(endPos.z - startPos.z);
    }

    public static int getHorSquaredDistance(Coord startPos, Coord endPos) {
        return Math.abs(endPos.x - startPos.x) + Math.abs(endPos.z - startPos.z);
    }

    public static int getVerDistance(Coord startPos, Coord endPos) {
        return Math.abs(endPos.y - startPos.y);
    }

    public static double getDistanceRatioToCenter(int point1, int point2, int pos) {
        double radius = (double)Math.abs(point2 - point1) / 2.0;
        double dar = Math.abs((double)Math.abs(pos - point1) - radius);
        return radius != 0.0 ? dar / radius : 0.0;
    }

    public static int parseInt(String string) {
        return MathUtils.parseInt(string, 0);
    }

    public static int parseInt(String string, int defaultValue) {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }
}

