/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission.core.grid;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasAcceptor;
import mekanism.api.gas.IGasHandler;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.IOxygenNetwork;
import micdoodle8.mods.galacticraft.api.transmission.core.path.PathfinderChecker;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkConnection;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.transmission.tile.IOxygenReceiver;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class OxygenNetwork
implements IOxygenNetwork {
    public Map<TileEntity, ForgeDirection> oxygenTiles = new HashMap<TileEntity, ForgeDirection>();
    private final Set<ITransmitter> pipes = new HashSet<ITransmitter>();

    @Override
    public float produce(float totalOxygen, TileEntity ... ignoreTiles) {
        float totalOxygenRequest;
        float remainingUsableOxygen = totalOxygen;
        if (!this.oxygenTiles.isEmpty() && (totalOxygenRequest = this.getRequest(ignoreTiles)) > 0.0f) {
            for (TileEntity tileEntity : new HashSet<TileEntity>(this.oxygenTiles.keySet())) {
                TileEntity tile;
                if (Arrays.asList(ignoreTiles).contains(tileEntity)) continue;
                if (tileEntity instanceof IOxygenReceiver) {
                    IOxygenReceiver oxygenTile = (IOxygenReceiver)tileEntity;
                    for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                        float oxygenToSend;
                        tile = new Vector3(tileEntity).modifyPositionFromSide(direction).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
                        if (!oxygenTile.canConnect(direction, NetworkType.OXYGEN) || !this.getTransmitters().contains(tile) || !((oxygenToSend = totalOxygen * (oxygenTile.getOxygenRequest(direction) / totalOxygenRequest)) > 0.0f)) continue;
                        remainingUsableOxygen -= ((IOxygenReceiver)tileEntity).receiveOxygen(direction, oxygenToSend, true);
                    }
                    continue;
                }
                if (NetworkConfigHandler.isMekanismV6Loaded() && tileEntity instanceof IGasHandler) {
                    IGasHandler gasHandler = (IGasHandler)tileEntity;
                    for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                        int oxygenToSend;
                        tile = new Vector3(tileEntity).modifyPositionFromSide(direction).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
                        if (!gasHandler.canReceiveGas(direction, (Gas)NetworkConfigHandler.gasOxygen) || !this.getTransmitters().contains(tile) || (oxygenToSend = (int)Math.floor(totalOxygen / (float)this.oxygenTiles.size())) <= 0) continue;
                        remainingUsableOxygen -= (float)gasHandler.receiveGas(direction, new GasStack((Gas)NetworkConfigHandler.gasOxygen, oxygenToSend));
                    }
                    continue;
                }
                if (!NetworkConfigHandler.isMekanismLoaded() || !(tileEntity instanceof IGasAcceptor)) continue;
                IGasAcceptor gasAcceptor = (IGasAcceptor)tileEntity;
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    int oxygenToSend;
                    tile = new Vector3(tileEntity).modifyPositionFromSide(direction).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
                    if (!gasAcceptor.canReceiveGas(direction, (Gas)NetworkConfigHandler.gasOxygen) || !this.getTransmitters().contains(tile) || (oxygenToSend = (int)Math.floor(totalOxygen / (float)this.oxygenTiles.size())) <= 0) continue;
                    remainingUsableOxygen -= (float)gasAcceptor.receiveGas(new GasStack((Gas)NetworkConfigHandler.gasOxygen, oxygenToSend));
                }
            }
        }
        return remainingUsableOxygen;
    }

    @Override
    public float getRequest(TileEntity ... ignoreTiles) {
        ArrayList<Float> requests = new ArrayList<Float>();
        for (TileEntity tileEntity : new HashSet<TileEntity>(this.oxygenTiles.keySet())) {
            if (Arrays.asList(ignoreTiles).contains(tileEntity) || !(tileEntity instanceof IOxygenReceiver) || tileEntity.func_70320_p() || tileEntity.field_70331_k.func_72796_p(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n) != tileEntity) continue;
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                Vector3 tileVec = new Vector3(tileEntity);
                TileEntity tile = tileVec.modifyPositionFromSide(direction).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
                if (!((IOxygenReceiver)tileEntity).canConnect(direction, NetworkType.OXYGEN) || !this.getTransmitters().contains(tile)) continue;
                requests.add(Float.valueOf(((IOxygenReceiver)tileEntity).getOxygenRequest(direction)));
            }
        }
        float total = 0.0f;
        for (Float f : requests) {
            total += f.floatValue();
        }
        return total / (float)requests.size();
    }

    @Override
    public Set<TileEntity> getAcceptors() {
        return this.oxygenTiles.keySet();
    }

    @Override
    public ForgeDirection getPossibleDirections(TileEntity tile) {
        return this.oxygenTiles.containsKey(tile) ? this.oxygenTiles.get(tile) : null;
    }

    @Override
    public void refresh() {
        this.oxygenTiles.clear();
        try {
            Iterator<ITransmitter> it = this.pipes.iterator();
            while (it.hasNext()) {
                ITransmitter transmitter = it.next();
                if (transmitter == null) {
                    it.remove();
                }
                transmitter.onNetworkChanged();
                if (((TileEntity)transmitter).func_70320_p() || ((TileEntity)transmitter).func_70314_l() == null) {
                    it.remove();
                    continue;
                }
                if (((TileEntity)transmitter).func_70314_l().func_72796_p(((TileEntity)transmitter).field_70329_l, ((TileEntity)transmitter).field_70330_m, ((TileEntity)transmitter).field_70327_n) != transmitter) {
                    it.remove();
                    continue;
                }
                transmitter.setNetwork(this);
                for (int i = 0; i < transmitter.getAdjacentConnections().length; ++i) {
                    TileEntity acceptor = transmitter.getAdjacentConnections()[i];
                    if (acceptor instanceof ITransmitter || !(acceptor instanceof IConnector)) continue;
                    this.oxygenTiles.put(acceptor, ForgeDirection.getOrientation((int)i));
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to refresh oxygen pipe network.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public Set<ITransmitter> getTransmitters() {
        return this.pipes;
    }

    @Override
    public IOxygenNetwork merge(IOxygenNetwork network) {
        if (network != null && network != this) {
            OxygenNetwork newNetwork = new OxygenNetwork();
            newNetwork.getTransmitters().addAll(this.getTransmitters());
            newNetwork.getTransmitters().addAll(network.getTransmitters());
            newNetwork.refresh();
            return newNetwork;
        }
        return this;
    }

    @Override
    public void split(ITransmitter splitPoint) {
        if (splitPoint instanceof TileEntity) {
            TileEntity[] connectedBlocks;
            this.getTransmitters().remove(splitPoint);
            for (TileEntity connectedBlockA : connectedBlocks = splitPoint.getAdjacentConnections()) {
                if (!(connectedBlockA instanceof INetworkConnection)) continue;
                for (TileEntity connectedBlockB : connectedBlocks) {
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof INetworkConnection)) continue;
                    PathfinderChecker finder = new PathfinderChecker(((TileEntity)splitPoint).field_70331_k, (INetworkConnection)connectedBlockB, NetworkType.OXYGEN, splitPoint);
                    finder.init(new Vector3(connectedBlockA));
                    if (finder.results.size() > 0) {
                        for (Vector3 node : finder.closedSet) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                            if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                            ((INetworkProvider)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    OxygenNetwork newNetwork = new OxygenNetwork();
                    for (Vector3 node : finder.closedSet) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                        if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                        newNetwork.getTransmitters().add((ITransmitter)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    public String toString() {
        return "OxygenNetwork[" + this.hashCode() + "|Pipes:" + this.pipes.size() + "|Acceptors:" + this.oxygenTiles.size() + "]";
    }
}

