/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAirLock;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAirLockController;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreBlockAirLockFrame
extends GCCoreBlockAdvancedTile {
    @SideOnly(value=Side.CLIENT)
    private Icon[] airLockIcons;
    public static int METADATA_AIR_LOCK_FRAME = 0;
    public static int METADATA_AIR_LOCK_CONTROLLER = 1;

    public GCCoreBlockAirLockFrame(int id, String assetName) {
        super(id, Material.field_76246_e);
        this.func_71848_c(1.0f);
        this.func_71884_a(Block.field_71977_i);
        this.func_111022_d(GalacticraftCore.ASSET_PREFIX + assetName);
        this.func_71864_b(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, METADATA_AIR_LOCK_FRAME));
        par3List.add(new ItemStack(par1, 1, METADATA_AIR_LOCK_CONTROLLER));
    }

    public CreativeTabs func_71882_w() {
        return GalacticraftCore.galacticraftTab;
    }

    public boolean func_71930_b(World par1World, int par2, int par3, int par4) {
        return true;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_71860_a(world, x, y, z, entityLiving, itemStack);
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof GCCoreTileEntityAirLockController && entityLiving instanceof EntityPlayer) {
            ((GCCoreTileEntityAirLockController)tile).ownerName = ((EntityPlayer)entityLiving).field_71092_bJ;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.airLockIcons = new Icon[8];
        this.airLockIcons[0] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "airlock_off");
        this.airLockIcons[1] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "airlock_on_1");
        this.airLockIcons[2] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "airlock_on_2");
        this.airLockIcons[3] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "airlock_on_3");
        this.airLockIcons[4] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "airlock_on_4");
        this.airLockIcons[5] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "airlock_on_5");
        this.airLockIcons[6] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "airlock_control_on");
        this.airLockIcons[7] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "airlock_control_off");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int par1, int par2) {
        if (par2 >= METADATA_AIR_LOCK_CONTROLLER) {
            if (par1 == ForgeDirection.UP.ordinal() || par1 == ForgeDirection.DOWN.ordinal()) {
                return this.airLockIcons[0];
            }
            return this.airLockIcons[7];
        }
        return this.airLockIcons[0];
    }

    public Icon func_71895_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int side) {
        if (par1IBlockAccess.func_72805_g(par2, par3, par4) >= METADATA_AIR_LOCK_CONTROLLER) {
            if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
                return this.airLockIcons[0];
            }
            TileEntity tile = par1IBlockAccess.func_72796_p(par2, par3, par4);
            if (tile instanceof GCCoreTileEntityAirLockController) {
                GCCoreTileEntityAirLockController controller = (GCCoreTileEntityAirLockController)tile;
                if (controller.active) {
                    return this.airLockIcons[6];
                }
                return this.airLockIcons[7];
            }
            return this.airLockIcons[6];
        }
        for (ForgeDirection orientation : ForgeDirection.values()) {
            Vector3 vector;
            Vector3 blockVec;
            Block connection;
            if (orientation == ForgeDirection.UNKNOWN || (connection = Block.field_71973_m[(blockVec = this.modifyPositionFromSide((vector = new Vector3(par2, par3, par4)).clone(), orientation, 1.0)).getBlockID(par1IBlockAccess)]) == null || !connection.equals(GCCoreBlocks.airLockSeal)) continue;
            if (orientation.offsetY == -1) {
                if (side == 0) {
                    return this.airLockIcons[1];
                }
                if (side == 1) {
                    return this.airLockIcons[0];
                }
                return this.airLockIcons[2];
            }
            if (orientation.offsetY == 1) {
                if (side == 0) {
                    return this.airLockIcons[0];
                }
                if (side == 1) {
                    return this.airLockIcons[1];
                }
                return this.airLockIcons[3];
            }
            if (orientation.ordinal() == side) {
                if (side == 0) {
                    return this.airLockIcons[0];
                }
                if (side == 1) {
                    return this.airLockIcons[1];
                }
                return this.airLockIcons[3];
            }
            if (orientation.getOpposite().ordinal() == side) {
                return this.airLockIcons[0];
            }
            blockVec = vector.clone().translate(new Vector3(orientation.offsetX, orientation.offsetY, orientation.offsetZ));
            connection = Block.field_71973_m[blockVec.getBlockID(par1IBlockAccess)];
            if (connection == null || !connection.equals(GCCoreBlocks.airLockSeal)) continue;
            if (orientation.offsetX == 1) {
                if (side == 0) {
                    return this.airLockIcons[4];
                }
                if (side == 1) {
                    return this.airLockIcons[4];
                }
                if (side == 3) {
                    return this.airLockIcons[4];
                }
                if (side != 2) continue;
                return this.airLockIcons[5];
            }
            if (orientation.offsetX == -1) {
                if (side == 0) {
                    return this.airLockIcons[5];
                }
                if (side == 1) {
                    return this.airLockIcons[5];
                }
                if (side == 3) {
                    return this.airLockIcons[5];
                }
                if (side != 2) continue;
                return this.airLockIcons[4];
            }
            if (orientation.offsetZ == 1) {
                if (side == 0) {
                    return this.airLockIcons[2];
                }
                if (side == 1) {
                    return this.airLockIcons[2];
                }
                if (side == 4) {
                    return this.airLockIcons[4];
                }
                if (side != 5) continue;
                return this.airLockIcons[5];
            }
            if (orientation.offsetZ != -1) continue;
            if (side == 0) {
                return this.airLockIcons[3];
            }
            if (side == 1) {
                return this.airLockIcons[3];
            }
            if (side == 4) {
                return this.airLockIcons[5];
            }
            if (side != 5) continue;
            return this.airLockIcons[4];
        }
        return this.airLockIcons[0];
    }

    public Vector3 modifyPositionFromSide(Vector3 vec, ForgeDirection side, double amount) {
        switch (side.ordinal()) {
            case 0: {
                vec.y -= amount;
                break;
            }
            case 1: {
                vec.y += amount;
                break;
            }
            case 2: {
                vec.z -= amount;
                break;
            }
            case 3: {
                vec.z += amount;
                break;
            }
            case 4: {
                vec.x -= amount;
                break;
            }
            case 5: {
                vec.x += amount;
            }
        }
        return vec;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata < METADATA_AIR_LOCK_CONTROLLER) {
            return new GCCoreTileEntityAirLock();
        }
        return new GCCoreTileEntityAirLockController();
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntity tile = world.func_72796_p(x, y, z);
        if (metadata >= METADATA_AIR_LOCK_CONTROLLER && tile instanceof GCCoreTileEntityAirLockController) {
            entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof GCCoreTileEntityAirLockController) {
            ((GCCoreTileEntityAirLockController)tile).unsealAirLock();
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public int func_71899_b(int metadata) {
        if (metadata >= METADATA_AIR_LOCK_CONTROLLER) {
            return METADATA_AIR_LOCK_CONTROLLER;
        }
        if (metadata >= METADATA_AIR_LOCK_FRAME) {
            return METADATA_AIR_LOCK_FRAME;
        }
        return 0;
    }
}

