/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.event;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.event.oxygen.GCCoreOxygenSuffocationEvent;
import micdoodle8.mods.galacticraft.api.item.IKeyItem;
import micdoodle8.mods.galacticraft.api.item.IKeyable;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicEvent;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCCoreDamageSource;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.client.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerSP;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerServer;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketSchematicList;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import net.minecraft.block.Block;
import net.minecraft.client.audio.SoundPool;
import net.minecraft.client.audio.SoundPoolEntry;
import net.minecraft.client.audio.SoundPoolProtocolHandler;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class GCCoreEvents {
    private List<SoundPlayEntry> soundPlayList = new ArrayList<SoundPlayEntry>();

    @ForgeSubscribe
    public void onWorldSave(WorldEvent.Save event) {
        ChunkLoadingCallback.save((WorldServer)event.world);
    }

    @ForgeSubscribe
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        ChunkLoadingCallback.load((WorldServer)event.world);
    }

    @ForgeSubscribe
    public void onWorldLoad(ChunkEvent.Load event) {
        if (!event.world.field_72995_K) {
            ChunkLoadingCallback.load((WorldServer)event.world);
        }
    }

    @ForgeSubscribe
    public void onEntityFall(LivingFallEvent event) {
        if (event.entityLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            event.distance *= ((IGalacticraftWorldProvider)event.entityLiving.field_70170_p.field_73011_w).getFallDamageModifier();
        }
    }

    @ForgeSubscribe
    public void onPlayerClicked(PlayerInteractEvent event) {
        ItemStack heldStack = event.entityPlayer.field_71071_by.func_70448_g();
        TileEntity tileClicked = event.entityPlayer.field_70170_p.func_72796_p(event.x, event.y, event.z);
        int idClicked = event.entityPlayer.field_70170_p.func_72798_a(event.x, event.y, event.z);
        if (heldStack != null) {
            if (tileClicked != null && tileClicked instanceof IKeyable) {
                if (event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK)) {
                    event.setCanceled(!((IKeyable)tileClicked).canBreak() && !event.entityPlayer.field_71075_bZ.field_75098_d);
                    return;
                }
                if (event.action.equals((Object)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK)) {
                    if (heldStack.func_77973_b() instanceof IKeyItem) {
                        if (((IKeyItem)heldStack.func_77973_b()).getTier(heldStack) == -1 || ((IKeyable)tileClicked).getTierOfKeyRequired() == -1 || ((IKeyItem)heldStack.func_77973_b()).getTier(heldStack) == ((IKeyable)tileClicked).getTierOfKeyRequired()) {
                            event.setCanceled(((IKeyable)tileClicked).onValidKeyActivated(event.entityPlayer, heldStack, event.face));
                        } else {
                            event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.entityPlayer, event.face));
                        }
                    } else {
                        event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.entityPlayer, event.face));
                    }
                }
            }
            if (event.entityPlayer.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && heldStack.func_77973_b() instanceof ItemFlintAndSteel && !event.entity.field_70170_p.field_72995_K && event.action.equals((Object)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && idClicked != Block.field_72091_am.field_71990_ca && !OxygenUtil.isAABBInBreathableAirBlock(event.entityLiving.field_70170_p, new Vector3(event.x, event.y, event.z), new Vector3(event.x + 1, event.y + 1, event.z + 1))) {
                event.setCanceled(true);
            }
        } else if (tileClicked != null && tileClicked instanceof IKeyable) {
            if (event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK)) {
                event.setCanceled(!((IKeyable)tileClicked).canBreak() && !event.entityPlayer.field_71075_bZ.field_75098_d);
                return;
            }
            event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.entityPlayer, event.face));
        }
    }

    @ForgeSubscribe
    public void entityLivingEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && !(event.entityLiving instanceof EntityPlayer) && !OxygenUtil.isAABBInBreathableAirBlock((Entity)event.entityLiving) && (!(event.entityLiving instanceof IEntityBreathable) || event.entityLiving instanceof IEntityBreathable && !((IEntityBreathable)event.entityLiving).canBreath()) && event.entityLiving.field_70173_aa % 100 == 0) {
            GCCoreOxygenSuffocationEvent.Pre suffocationEvent = new GCCoreOxygenSuffocationEvent.Pre(event.entityLiving);
            MinecraftForge.EVENT_BUS.post((Event)suffocationEvent);
            if (suffocationEvent.isCanceled()) {
                return;
            }
            event.entityLiving.func_70097_a((DamageSource)GCCoreDamageSource.oxygenSuffocation, 1.0f);
            GCCoreOxygenSuffocationEvent.Post suffocationEventPost = new GCCoreOxygenSuffocationEvent.Post(event.entityLiving);
            MinecraftForge.EVENT_BUS.post((Event)suffocationEventPost);
        }
    }

    @ForgeSubscribe
    public void onBucketFill(FillBucketEvent event) {
        ItemStack result = this.fillCustomBucket(event.world, event.target);
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }

    public ItemStack fillCustomBucket(World world, MovingObjectPosition pos) {
        int blockID;
        Class<?> buildCraftClass = null;
        int bcOilID1 = -1;
        int bcOilID2 = -1;
        Item bcOilBucket = null;
        try {
            buildCraftClass = Class.forName("buildcraft.BuildCraftEnergy");
            if (buildCraftClass != null) {
                for (Field f : buildCraftClass.getFields()) {
                    Item item;
                    Block block;
                    if (f.getName().equals("oilMoving")) {
                        block = (Block)f.get(null);
                        bcOilID1 = block.field_71990_ca;
                        continue;
                    }
                    if (f.getName().equals("oilStill")) {
                        block = (Block)f.get(null);
                        bcOilID2 = block.field_71990_ca;
                        continue;
                    }
                    if (!f.getName().equals("bucketOil")) continue;
                    bcOilBucket = item = (Item)f.get(null);
                }
            }
        }
        catch (Throwable cnfe) {
            // empty catch block
        }
        if (((blockID = world.func_72798_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d)) == bcOilID1 || blockID == bcOilID2 || blockID == GCCoreBlocks.crudeOilStill.field_71990_ca) && world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == 0 && bcOilBucket != null) {
            world.func_94571_i(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            return new ItemStack(bcOilBucket);
        }
        return null;
    }

    @ForgeSubscribe
    public void populate(PopulateChunkEvent.Post event) {
        boolean doGen = TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkX, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        boolean doGen2 = false;
        int[] arr$ = GCCoreConfigManager.externalOilGen;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer dim = arr$[i$];
            if (dim != event.world.field_73011_w.field_76574_g) continue;
            doGen2 = true;
            break;
        }
        if (!doGen || !(event.world.field_73011_w instanceof IGalacticraftWorldProvider) && !doGen2) {
            return;
        }
        int worldX = event.chunkX << 4;
        int worldZ = event.chunkZ << 4;
        GCCoreEvents.doPopulate(event.world, event.rand, worldX + event.rand.nextInt(16), worldZ + event.rand.nextInt(16));
    }

    public static void doPopulate(World world, Random rand, int x, int z) {
        boolean flag2;
        BiomeGenBase biomegenbase = world.func_72807_a(x + 16, z + 16);
        if (biomegenbase.field_76756_M == BiomeGenBase.field_76779_k.field_76756_M || biomegenbase.field_76756_M == BiomeGenBase.field_76778_j.field_76756_M) {
            return;
        }
        double randMod = Math.min(0.5, 0.2 * GCCoreConfigManager.oilGenFactor);
        boolean flag1 = rand.nextDouble() <= randMod;
        boolean bl = flag2 = rand.nextDouble() <= randMod;
        if (flag1 || flag2) {
            int cx = x;
            int cy = 20 + rand.nextInt(11);
            int cz = z;
            int r = 2 + rand.nextInt(2);
            int r2 = r * r;
            for (int bx = -r; bx <= r; ++bx) {
                for (int by = -r; by <= r; ++by) {
                    for (int bz = -r; bz <= r; ++bz) {
                        int d2 = bx * bx + by * by + bz * bz;
                        if (d2 > r2) continue;
                        world.func_72832_d(bx + cx, by + cy, bz + cz, GCCoreBlocks.crudeOilStill.field_71990_ca, 0, 2);
                    }
                }
            }
        }
    }

    @ForgeSubscribe
    public void schematicUnlocked(SchematicEvent.Unlock event) {
        GCCorePlayerMP player = (GCCorePlayerMP)event.player;
        if (!player.getUnlockedSchematics().contains(event.page)) {
            player.getUnlockedSchematics().add(event.page);
            Collections.sort(player.getUnlockedSchematics());
            if (player != null && player.field_71135_a != null) {
                player.field_71135_a.func_72567_b(GCCorePacketSchematicList.buildSchematicListPacket(player.getUnlockedSchematics()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void schematicFlipEvent(SchematicEvent.FlipPage event) {
        ISchematicPage page = null;
        switch (event.direction) {
            case 1: {
                page = GCCoreEvents.getNextSchematic(event.index);
                break;
            }
            case -1: {
                page = GCCoreEvents.getLastSchematic(event.index);
            }
        }
        if (page != null) {
            PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerServer.EnumPacketServer.OPEN_SCHEMATIC_PAGE, new Object[]{page.getPageID()}));
            FMLClientHandler.instance().getClient().field_71439_g.openGui((Object)GalacticraftCore.instance, page.getGuiID(), FMLClientHandler.instance().getClient().field_71439_g.field_70170_p, (int)FMLClientHandler.instance().getClient().field_71439_g.field_70165_t, (int)FMLClientHandler.instance().getClient().field_71439_g.field_70163_u, (int)FMLClientHandler.instance().getClient().field_71439_g.field_70161_v);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static ISchematicPage getNextSchematic(int currentIndex) {
        HashMap<Integer, Integer> idList = new HashMap<Integer, Integer>();
        GCCorePlayerSP player = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, false);
        for (int i = 0; i < player.unlockedSchematics.size(); ++i) {
            idList.put(i, player.unlockedSchematics.get(i).getPageID());
        }
        TreeSet keys = new TreeSet(idList.keySet());
        Iterator iterator = keys.iterator();
        for (int count = 0; count < keys.size(); ++count) {
            int i = (Integer)iterator.next();
            ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)idList.get(i));
            if (page.getPageID() != currentIndex) continue;
            if (count + 1 < player.unlockedSchematics.size()) {
                return player.unlockedSchematics.get(count + 1);
            }
            return null;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static ISchematicPage getLastSchematic(int currentIndex) {
        HashMap<Integer, Integer> idList = new HashMap<Integer, Integer>();
        GCCorePlayerSP player = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, false);
        for (int i = 0; i < player.unlockedSchematics.size(); ++i) {
            idList.put(i, player.unlockedSchematics.get(i).getPageID());
        }
        TreeSet keys = new TreeSet(idList.keySet());
        Iterator iterator = keys.iterator();
        for (int count = 0; count < keys.size(); ++count) {
            int i = (Integer)iterator.next();
            ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)idList.get(i));
            if (page.getPageID() != currentIndex) continue;
            if (count - 1 >= 0) {
                return player.unlockedSchematics.get(count - 1);
            }
            return null;
        }
        return null;
    }

    @ForgeSubscribe
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof GCCorePlayerMP && !event.entityLiving.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            for (int i = 0; i < ((GCCorePlayerMP)event.entityLiving).getExtendedInventory().func_70302_i_(); ++i) {
                ItemStack stack = ((GCCorePlayerMP)event.entityLiving).getExtendedInventory().func_70301_a(i);
                if (stack == null) continue;
                ((GCCorePlayerMP)event.entityLiving).func_71019_a(stack, true);
                ((GCCorePlayerMP)event.entityLiving).getExtendedInventory().func_70299_a(i, null);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onSoundLoad(SoundLoadEvent event) {
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "ambience/scaryscape.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "ambience/singledrip1.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "ambience/singledrip2.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "ambience/singledrip3.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "ambience/singledrip4.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "ambience/singledrip5.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "ambience/singledrip6.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "ambience/singledrip7.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "ambience/singledrip8.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "entity/bossdeath.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "entity/bosslaugh.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "entity/bossliving.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "entity/slime_death.ogg");
        ClientProxyCore.newMusic.add(this.func_110654_c(event.manager.field_77377_d, GalacticraftCore.ASSET_PREFIX + "music/mars_JC.ogg"));
        ClientProxyCore.newMusic.add(this.func_110654_c(event.manager.field_77377_d, GalacticraftCore.ASSET_PREFIX + "music/mimas_JC.ogg"));
        ClientProxyCore.newMusic.add(this.func_110654_c(event.manager.field_77377_d, GalacticraftCore.ASSET_PREFIX + "music/orbit_JC.ogg"));
        ClientProxyCore.newMusic.add(this.func_110654_c(event.manager.field_77377_d, GalacticraftCore.ASSET_PREFIX + "music/scary_ambience.ogg"));
        ClientProxyCore.newMusic.add(this.func_110654_c(event.manager.field_77377_d, GalacticraftCore.ASSET_PREFIX + "music/spacerace_JC.ogg"));
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "player/closeairlock.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "player/openairlock.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "player/parachute.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "player/unlockchest.ogg");
        event.manager.func_77372_a(GalacticraftCore.ASSET_PREFIX + "shuttle/shuttle.ogg");
    }

    @SideOnly(value=Side.CLIENT)
    private SoundPoolEntry func_110654_c(SoundPool pool, String par1Str) {
        try {
            ResourceLocation resourcelocation = new ResourceLocation(par1Str);
            String s1 = String.format("%s:%s:%s/%s", "mcsounddomain", resourcelocation.func_110624_b(), "sound", resourcelocation.func_110623_a());
            SoundPoolProtocolHandler soundpoolprotocolhandler = new SoundPoolProtocolHandler(pool);
            return new SoundPoolEntry(par1Str, new URL((URL)null, s1, (URLStreamHandler)soundpoolprotocolhandler));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onLeaveBedButtonClicked(GalacticraftCore.SleepCancelledEvent event) {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (player instanceof GCCorePlayerSP) {
            ((GCCorePlayerSP)player).wakeUpPlayer(false, true, true, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onSoundPlayed(PlaySoundEvent event) {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        PlayerGearData gearData = null;
        for (PlayerGearData gearData2 : ClientProxyCore.playerItemData) {
            if (!gearData2.getPlayer().field_71092_bJ.equals(player.field_71092_bJ)) continue;
            gearData = gearData2;
            break;
        }
        if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (gearData == null || gearData.getFrequencyModule() == -1)) {
            for (int i = 0; i < this.soundPlayList.size(); ++i) {
                SoundPlayEntry entry = this.soundPlayList.get(i);
                if (!entry.name.equals(event.name) || entry.x != event.x || entry.y != event.y || entry.z != event.z || entry.volume != event.volume) continue;
                this.soundPlayList.remove(i);
                event.result = event.source;
                return;
            }
            float newVolume = event.volume / Math.max(0.01f, ((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getSoundVolReductionAmount());
            this.soundPlayList.add(new SoundPlayEntry(event.name, event.x, event.y, event.z, newVolume));
            event.manager.func_77364_b(event.name, event.x, event.y, event.z, newVolume, event.pitch);
            event.result = null;
            return;
        }
        event.result = event.source;
    }

    private static class SoundPlayEntry {
        private final String name;
        private final float x;
        private final float y;
        private final float z;
        private final float volume;

        private SoundPlayEntry(String name, float x, float y, float z, float volume) {
            this.name = name;
            this.volume = volume;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

