/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.oxygen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.oxygen.BlockVec3;
import micdoodle8.mods.galacticraft.core.oxygen.ThreadFindSeal;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenSealer;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class OxygenPressureProtocol {
    public static ArrayList<Integer> vanillaPermeableBlocks = new ArrayList();
    public static Map<Integer, ArrayList<Integer>> nonPermeableBlocks = new HashMap<Integer, ArrayList<Integer>>();
    public static final int MAX_SEAL_CHECKS = 400;

    public static void updateSealerStatus(GCCoreTileEntityOxygenSealer head) {
        try {
            head.threadSeal = new ThreadFindSeal(head);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public static ThreadFindSeal onEdgeBlockUpdated(World world, BlockVec3 vec) {
        return new ThreadFindSeal(world, vec, 2000, new ArrayList<GCCoreTileEntityOxygenSealer>());
    }

    public static boolean canBlockPassAir(World world, int id, BlockVec3 vec, int side) {
        if (vanillaPermeableBlocks.contains(id)) {
            return true;
        }
        Block block = Block.field_71973_m[id];
        if (!block.func_71926_d()) {
            if (block instanceof IPartialSealableBlock) {
                return !((IPartialSealableBlock)block).isSealed(world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)side));
            }
            return !nonPermeableBlocks.containsKey(id) || !nonPermeableBlocks.get(id).contains(vec.getBlockMetadata((IBlockAccess)world));
        }
        return false;
    }

    static {
        vanillaPermeableBlocks.add(Block.field_71945_L.field_71990_ca);
        try {
            for (String s : GCCoreConfigManager.sealableIDs) {
                String[] split = s.split(":");
                if (nonPermeableBlocks.containsKey(Integer.parseInt(split[0]))) {
                    ArrayList<Integer> l = nonPermeableBlocks.get(Integer.parseInt(split[0]));
                    l.add(Integer.parseInt(split[1]));
                    nonPermeableBlocks.put(Integer.parseInt(split[0]), l);
                    continue;
                }
                ArrayList<Integer> a = new ArrayList<Integer>();
                a.add(Integer.parseInt(split[1]));
                nonPermeableBlocks.put(Integer.parseInt(split[0]), a);
            }
        }
        catch (Exception e) {
            System.err.println();
            System.err.println("Error finding sealable IDs from the Galacticraft config, check that they are listed properly!");
            System.err.println();
            e.printStackTrace();
        }
    }
}

