/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.oxygen;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.oxygen.BlockVec3;
import micdoodle8.mods.galacticraft.core.oxygen.OxygenPressureProtocol;
import micdoodle8.mods.galacticraft.core.tick.GCCoreTickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledBlockChange;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ThreadFindSeal
extends Thread {
    public World world;
    public BlockVec3 head;
    public AtomicBoolean sealedFinal = new AtomicBoolean();
    private boolean sealed;
    public List<GCCoreTileEntityOxygenSealer> sealers;
    public List<BlockVec3> oxygenReliantBlocks;
    public HashSet<BlockVec3> checked;
    public HashSet<BlockVec3> partiallySealableChecked;
    public int checkCount;
    public static AtomicBoolean anylooping = new AtomicBoolean();
    public AtomicBoolean looping = new AtomicBoolean();
    private HashMap<BlockVec3, GCCoreTileEntityOxygenSealer> sealersAround = new HashMap();
    private int breatheableAirID;
    private int oxygenSealerID;
    private List<BlockVec3> currentLayer = new LinkedList<BlockVec3>();
    private List<BlockVec3> nextLayer;
    private List<BlockVec3> airToReplace = new LinkedList<BlockVec3>();
    private List<BlockVec3> breatheableToReplace = new LinkedList<BlockVec3>();
    private List<GCCoreTileEntityOxygenSealer> otherSealers = new LinkedList<GCCoreTileEntityOxygenSealer>();

    public ThreadFindSeal(GCCoreTileEntityOxygenSealer sealer) {
        this(sealer.field_70331_k, new BlockVec3(sealer).translate(0, 1, 0), sealer.getFindSealChecks(), new ArrayList<GCCoreTileEntityOxygenSealer>(Arrays.asList(sealer)));
    }

    public ThreadFindSeal(World world, BlockVec3 head, int checkCount, List<GCCoreTileEntityOxygenSealer> sealers) {
        super("GC Sealer Roomfinder Thread");
        anylooping.set(true);
        this.world = world;
        this.head = head;
        this.checkCount = checkCount;
        this.sealers = sealers;
        this.oxygenReliantBlocks = new ArrayList<BlockVec3>();
        this.checked = new HashSet();
        this.partiallySealableChecked = new HashSet();
        this.breatheableAirID = GCCoreBlocks.breatheableAir.field_71990_ca;
        this.oxygenSealerID = GCCoreBlocks.oxygenSealer.field_71990_ca;
        if (this.isAlive()) {
            this.interrupt();
        }
        for (TileEntity tile : new ArrayList(world.field_73009_h)) {
            if (!(tile instanceof GCCoreTileEntityOxygenSealer) || !(tile.func_70318_a((double)head.x, (double)head.y, (double)head.z) < 4194304.0)) continue;
            this.sealersAround.put(new BlockVec3(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n), (GCCoreTileEntityOxygenSealer)tile);
        }
        this.looping.set(true);
        this.start();
    }

    @Override
    public void run() {
        LinkedList<ScheduledBlockChange> changeList;
        long time1 = System.nanoTime();
        this.sealed = true;
        this.checked.add(this.head);
        this.currentLayer.clear();
        this.nextLayer = new LinkedList<BlockVec3>();
        this.airToReplace.clear();
        if (this.checkCount > 0) {
            this.currentLayer.add(this.head.clone());
            if (this.head.x < -29990000 || this.head.z < -29990000 || this.head.x >= 29990000 || this.head.z >= 29990000) {
                this.doLayerNearMapEdge();
            } else {
                this.doLayer();
            }
        } else {
            this.sealed = false;
        }
        long time2 = System.nanoTime();
        if (this.sealed) {
            if (!this.airToReplace.isEmpty()) {
                changeList = new LinkedList<ScheduledBlockChange>();
                for (BlockVec3 checkedVec : this.airToReplace) {
                    changeList.add(new ScheduledBlockChange(checkedVec.clone(), this.breatheableAirID, 0, 3));
                }
                GCCoreTickHandlerServer.scheduleNewBlockChange(this.world.field_73011_w.field_76574_g, changeList);
            }
        } else {
            this.checked.clear();
            this.breatheableToReplace.clear();
            this.otherSealers.clear();
            this.currentLayer.clear();
            this.currentLayer.add(this.head.clone());
            this.nextLayer = new LinkedList<BlockVec3>();
            this.loopThroughD();
            if (!this.otherSealers.isEmpty()) {
                List<GCCoreTileEntityOxygenSealer> sealersDone = this.sealers;
                for (GCCoreTileEntityOxygenSealer otherSealer : this.otherSealers) {
                    if (!sealersDone.contains(otherSealer) && otherSealer.getFindSealChecks() > 0) {
                        BlockVec3 newhead = new BlockVec3(otherSealer).translate(0, 1, 0);
                        this.sealed = true;
                        this.checkCount = otherSealer.getFindSealChecks();
                        this.sealers = new LinkedList<GCCoreTileEntityOxygenSealer>();
                        this.sealers.add(otherSealer);
                        this.checked.clear();
                        this.checked.add(newhead);
                        this.currentLayer.clear();
                        this.nextLayer = new LinkedList<BlockVec3>();
                        this.airToReplace.clear();
                        this.currentLayer.add(newhead.clone());
                        if (newhead.x < -29990000 || newhead.z < -29990000 || newhead.x >= 29990000 || newhead.z >= 29990000) {
                            this.doLayerNearMapEdge();
                        } else {
                            this.doLayer();
                        }
                        if (this.sealed) {
                            GCCoreTileEntityOxygenSealer oldHead;
                            if (GCCoreConfigManager.enableDebug) {
                                FMLLog.info((String)("Oxygen Sealer replacing head at x" + this.head.x + " y" + (this.head.y - 1) + " z" + this.head.z), (Object[])new Object[0]);
                            }
                            if (!this.sealers.contains(oldHead = sealersDone.get(0))) {
                                this.sealers.add(oldHead);
                            }
                            this.head = newhead.clone();
                            otherSealer.threadSeal = this;
                            otherSealer.stopSealThreadCooldown = 50;
                            break;
                        }
                    }
                    this.sealers = sealersDone;
                }
            }
            if (!this.sealed && !this.breatheableToReplace.isEmpty()) {
                changeList = new LinkedList();
                for (BlockVec3 checkedVec : this.breatheableToReplace) {
                    changeList.add(new ScheduledBlockChange(checkedVec.clone(), 0, 0, 3));
                }
                GCCoreTickHandlerServer.scheduleNewBlockChange(this.world.field_73011_w.field_76574_g, changeList);
            }
        }
        GCCoreTileEntityOxygenSealer headSealer = this.sealersAround.get(this.head.translate(0, -1, 0));
        for (GCCoreTileEntityOxygenSealer sealer : this.sealers) {
            if (sealer == headSealer || headSealer == null) continue;
            sealer.threadSeal = this;
            sealer.stopSealThreadCooldown = headSealer.stopSealThreadCooldown + 51;
        }
        this.airToReplace.clear();
        this.breatheableToReplace.clear();
        this.looping.set(false);
        if (GCCoreConfigManager.enableDebug) {
            long time3 = System.nanoTime();
            FMLLog.info((String)("Oxygen Sealer Check Completed at x" + this.head.x + " y" + this.head.y + " z" + this.head.z), (Object[])new Object[0]);
            FMLLog.info((String)("   Sealed: " + this.sealed), (Object[])new Object[0]);
            FMLLog.info((String)("   Loop Time taken: " + (double)(time2 - time1) / 1000000.0 + "ms"), (Object[])new Object[0]);
            FMLLog.info((String)("   Place Time taken: " + (double)(time3 - time2) / 1000000.0 + "ms"), (Object[])new Object[0]);
            FMLLog.info((String)("   Total Time taken: " + (double)(time3 - time1) / 1000000.0 + "ms"), (Object[])new Object[0]);
            FMLLog.info((String)("   Found: " + this.sealers.size() + " sealers"), (Object[])new Object[0]);
            FMLLog.info((String)("   Looped through: " + this.checked.size() + " blocks"), (Object[])new Object[0]);
        }
        this.checked.clear();
        this.sealedFinal.set(this.sealed);
        anylooping.set(false);
    }

    private void loopThroughD() {
        while (this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                for (int side = 0; side < 6; ++side) {
                    GCCoreTileEntityOxygenSealer sealer;
                    BlockVec3 sideVec = vec.newVecSide(side);
                    if (this.checked.contains(sideVec)) continue;
                    this.checked.add(sideVec);
                    int id = sideVec.getBlockID(this.world);
                    if (id == this.breatheableAirID) {
                        this.breatheableToReplace.add(sideVec);
                        this.nextLayer.add(sideVec);
                        continue;
                    }
                    if (id != this.oxygenSealerID || (sealer = this.sealersAround.get(sideVec)) == null || this.sealers.contains(sealer)) continue;
                    this.otherSealers.add(sealer);
                }
            }
            this.currentLayer = this.nextLayer;
            this.nextLayer = new LinkedList<BlockVec3>();
        }
    }

    private void doLayer() {
        block0: while (this.sealed && this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                if (this.partiallySealableChecked.isEmpty() || !this.partiallySealableChecked.contains(vec)) {
                    for (int side = 0; side < 6; ++side) {
                        int id;
                        BlockVec3 sideVec = vec.newVecSide(side);
                        if (this.checked.contains(sideVec)) continue;
                        if (this.checkCount > 0) {
                            GCCoreTileEntityOxygenSealer sealer;
                            --this.checkCount;
                            this.checked.add(sideVec);
                            id = sideVec.getBlockIDsafe(this.world);
                            if (id == 0) {
                                this.nextLayer.add(sideVec);
                                this.airToReplace.add(sideVec);
                                continue;
                            }
                            if (id == -1) {
                                this.checkCount = 0;
                                this.sealed = false;
                                break block0;
                            }
                            if (id == this.breatheableAirID || this.canBlockPassAir(id, sideVec, side)) {
                                this.nextLayer.add(sideVec);
                                continue;
                            }
                            if (id != this.oxygenSealerID || (sealer = this.sealersAround.get(sideVec)) == null || this.sealers.contains(sealer)) continue;
                            this.sealers.add(sealer);
                            this.checkCount += sealer.getFindSealChecks();
                            continue;
                        }
                        if (!this.sealed || (id = sideVec.getBlockIDsafe(this.world)) != 0 && id != this.breatheableAirID && id != -1 && !this.canBlockPassAir(id, sideVec, side)) continue;
                        this.sealed = false;
                        break block0;
                    }
                    continue;
                }
                Block block = Block.field_71973_m[vec.getBlockIDsafe(this.world)];
                if (!(block instanceof IPartialSealableBlock)) continue;
                IPartialSealableBlock partialBlock = (IPartialSealableBlock)block;
                for (int side = 0; side < 6; ++side) {
                    int id;
                    BlockVec3 sideVec;
                    if (partialBlock.isSealed(this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)(side ^ 1))) || this.checked.contains(sideVec = vec.newVecSide(side))) continue;
                    if (this.checkCount > 0) {
                        GCCoreTileEntityOxygenSealer sealer;
                        --this.checkCount;
                        this.checked.add(sideVec);
                        id = sideVec.getBlockIDsafe(this.world);
                        if (id == 0) {
                            this.nextLayer.add(sideVec);
                            this.airToReplace.add(sideVec);
                            continue;
                        }
                        if (id == -1) {
                            this.checkCount = 0;
                            this.sealed = false;
                            break block0;
                        }
                        if (id == this.breatheableAirID || this.canBlockPassAir(id, sideVec, side)) {
                            this.nextLayer.add(sideVec);
                            continue;
                        }
                        if (id != this.oxygenSealerID || (sealer = this.sealersAround.get(sideVec)) == null || this.sealers.contains(sealer)) continue;
                        this.sealers.add(sealer);
                        this.checkCount += sealer.getFindSealChecks();
                        continue;
                    }
                    if (!this.sealed || (id = sideVec.getBlockIDsafe(this.world)) != 0 && id != this.breatheableAirID && id != -1 && !this.canBlockPassAir(id, sideVec, side)) continue;
                    this.sealed = false;
                    break block0;
                }
            }
            this.currentLayer = this.nextLayer;
            this.nextLayer = new LinkedList<BlockVec3>();
        }
    }

    private void doLayerNearMapEdge() {
        block0: while (this.sealed && this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                for (int side = 0; side < 6; ++side) {
                    int id;
                    BlockVec3 sideVec = vec.newVecSide(side);
                    if (this.checked.contains(sideVec)) continue;
                    if (this.checkCount > 0) {
                        GCCoreTileEntityOxygenSealer sealer;
                        --this.checkCount;
                        this.checked.add(sideVec);
                        id = sideVec.getBlockID(this.world);
                        if (id == 0) {
                            this.nextLayer.add(sideVec);
                            this.airToReplace.add(sideVec);
                            continue;
                        }
                        if (id == -1) {
                            this.checkCount = 0;
                            this.sealed = false;
                            break block0;
                        }
                        if (id == this.breatheableAirID || this.canBlockPassAir(id, sideVec, side)) {
                            this.nextLayer.add(sideVec);
                            continue;
                        }
                        if (id != this.oxygenSealerID || (sealer = this.sealersAround.get(sideVec)) == null || this.sealers.contains(sealer)) continue;
                        this.sealers.add(sealer);
                        this.checkCount += sealer.getFindSealChecks();
                        continue;
                    }
                    if (!this.sealed || (id = sideVec.getBlockID(this.world)) != 0 && id != this.breatheableAirID && id != -1 && !this.canBlockPassAir(id, sideVec, side)) continue;
                    this.sealed = false;
                    break block0;
                }
            }
            this.currentLayer = this.nextLayer;
            this.nextLayer = new LinkedList<BlockVec3>();
        }
    }

    private boolean canBlockPassAir(int id, BlockVec3 vec, int side) {
        if (OxygenPressureProtocol.vanillaPermeableBlocks.contains(id)) {
            return true;
        }
        Block block = Block.field_71973_m[id];
        if (!block.func_71926_d()) {
            if (block instanceof IPartialSealableBlock) {
                if (((IPartialSealableBlock)block).isSealed(this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)side))) {
                    this.checked.remove(vec);
                    --this.checkCount;
                    return false;
                }
                this.partiallySealableChecked.add(vec);
                return true;
            }
            return !OxygenPressureProtocol.nonPermeableBlocks.containsKey(id) || !OxygenPressureProtocol.nonPermeableBlocks.get(id).contains(vec.getBlockMetadata((IBlockAccess)this.world));
        }
        return false;
    }
}

