/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tick;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledBlockChange;
import net.minecraft.entity.Entity;
import net.minecraft.world.WorldServer;

public class GCCoreTickHandlerServer
implements ITickHandler {
    private static Map<Integer, List<ScheduledBlockChange>> scheduledBlockChanges = new ConcurrentHashMap<Integer, List<ScheduledBlockChange>>();

    public static void scheduleNewBlockChange(int dimID, ScheduledBlockChange change) {
        List<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList == null) {
            changeList = new ArrayList<ScheduledBlockChange>();
        }
        changeList.add(change);
        scheduledBlockChanges.put(dimID, changeList);
    }

    public static void scheduleNewBlockChange(int dimID, List<ScheduledBlockChange> changeAdd) {
        List<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList == null) {
            changeList = new ArrayList<ScheduledBlockChange>();
        }
        changeList.addAll(changeAdd);
        scheduledBlockChanges.put(dimID, changeList);
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        if (type.equals(EnumSet.of(TickType.WORLD))) {
            WorldServer world = (WorldServer)tickData[0];
            List<ScheduledBlockChange> changeList = scheduledBlockChanges.get(world.field_73011_w.field_76574_g);
            if (changeList != null && !changeList.isEmpty()) {
                ArrayList<ScheduledBlockChange> scheduledChanges = new ArrayList<ScheduledBlockChange>(changeList);
                for (ScheduledBlockChange change : scheduledChanges) {
                    if (change == null || change.getChangePosition() == null) continue;
                    world.func_72832_d(change.getChangePosition().x, change.getChangePosition().y, change.getChangePosition().z, change.getChangeID(), change.getChangeMeta(), change.getChangeFlag());
                }
                scheduledBlockChanges.get(world.field_73011_w.field_76574_g).clear();
                scheduledBlockChanges.remove(world.field_73011_w.field_76574_g);
            }
            if (world.field_73011_w instanceof IOrbitDimension) {
                Object[] entityList;
                for (Object o : entityList = world.field_72996_f.toArray()) {
                    IOrbitDimension dimension;
                    if (!(o instanceof Entity)) continue;
                    Entity e = (Entity)o;
                    if (!(e.field_70170_p.field_73011_w instanceof IOrbitDimension) || !(e.field_70163_u <= (double)(dimension = (IOrbitDimension)e.field_70170_p.field_73011_w).getYCoordToTeleportToPlanet())) continue;
                    Integer dim = WorldUtil.getProviderForName((String)dimension.getPlanetToOrbit()).field_76574_g;
                    WorldUtil.transferEntityToDimension(e, dim, world, false, null);
                }
            }
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "Galacticraft Core Common";
    }
}

