/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GCCoreAnnotations;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockParachest;
import micdoodle8.mods.galacticraft.core.entities.IScaleableFuelLevel;
import micdoodle8.mods.galacticraft.core.inventory.GCCoreContainerParachest;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerServer;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class GCCoreTileEntityParachest
extends GCCoreTileEntityAdvanced
implements IInventory,
IPacketReceiver,
IScaleableFuelLevel {
    private final int tankCapacity = 5000;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    public ItemStack[] chestContents = new ItemStack[3];
    public boolean adjacentChestChecked = false;
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;

    public void func_70312_q() {
        super.func_70312_q();
        if (this.field_70331_k != null && this.field_70331_k.field_72995_K) {
            PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerServer.EnumPacketServer.UPDATE_DYNAMIC_TILE_INV, new Object[]{this.field_70329_l, this.field_70330_m, this.field_70327_n}));
        }
    }

    @Override
    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.fuelTank.getFluid() == null ? 0.0 : (double)this.fuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    public int func_70302_i_() {
        return this.chestContents.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.chestContents[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.chestContents[par1] != null) {
            if (this.chestContents[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.chestContents[par1];
                this.chestContents[par1] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.chestContents[par1].func_77979_a(par2);
            if (this.chestContents[par1].field_77994_a == 0) {
                this.chestContents[par1] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.chestContents[par1] != null) {
            ItemStack itemstack = this.chestContents[par1];
            this.chestContents[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.chestContents[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70303_b() {
        return StatCollector.func_74838_a((String)"container.parachest.name");
    }

    public boolean func_94042_c() {
        return true;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList nbttaglist = nbt.func_74761_m("Items");
        this.chestContents = new ItemStack[nbt.func_74762_e("chestContentLength")];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.chestContents.length) continue;
            this.chestContents[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("chestContentLength", this.chestContents.length);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.chestContents.length; ++i) {
            if (this.chestContents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.chestContents[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70321_h() {
        super.func_70321_h();
        this.adjacentChestChecked = false;
    }

    @Override
    public void func_70316_g() {
        FluidStack liquid;
        float f;
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.numUsingPlayers != 0 && (this.ticks + (long)this.field_70329_l + (long)this.field_70330_m + (long)this.field_70327_n) % 200L == 0L) {
            this.numUsingPlayers = 0;
            f = 5.0f;
            List list = this.field_70331_k.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72332_a().func_72299_a((double)((float)this.field_70329_l - f), (double)((float)this.field_70330_m - f), (double)((float)this.field_70327_n - f), (double)((float)(this.field_70329_l + 1) + f), (double)((float)(this.field_70330_m + 1) + f), (double)((float)(this.field_70327_n + 1) + f)));
            for (EntityPlayer entityplayer : list) {
                if (!(entityplayer.field_71070_bA instanceof GCCoreContainerParachest)) continue;
                ++this.numUsingPlayers;
            }
        }
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)this.field_70329_l + 0.5;
            double d0 = (double)this.field_70327_n + 0.5;
            this.field_70331_k.func_72908_a(d1, (double)this.field_70330_m + 0.5, d0, "random.chestopen", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d0 = (double)this.field_70329_l + 0.5;
                double d2 = (double)this.field_70327_n + 0.5;
                this.field_70331_k.func_72908_a(d0, (double)this.field_70330_m + 0.5, d2, "random.chestclosed", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        if (!this.field_70331_k.field_72995_K && (liquid = this.fuelTank.getFluid()) != null && this.fuelTank.getFluid() != null && this.fuelTank.getFluid().getFluid().getName().equalsIgnoreCase("Fuel") && FluidContainerRegistry.isEmptyContainer((ItemStack)this.chestContents[this.chestContents.length - 1])) {
            boolean isCanister = this.chestContents[this.chestContents.length - 1].func_77969_a(new ItemStack(GCCoreItems.oilCanister, 1, GCCoreItems.oilCanister.func_77612_l()));
            int amountToFill = Math.min(liquid.amount, isCanister ? GCCoreItems.fuelCanister.func_77612_l() - 1 : 1000);
            this.chestContents[this.chestContents.length - 1] = isCanister ? new ItemStack(GCCoreItems.fuelCanister, 1, GCCoreItems.fuelCanister.func_77612_l() - amountToFill) : FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)this.chestContents[this.chestContents.length - 1]);
            this.fuelTank.drain(amountToFill, true);
        }
    }

    public Packet getPacket() {
        return GCCorePacketManager.getPacket("GCCoreEntities", this, this.fuelTank.getFluid() == null ? 0 : this.fuelTank.getFluidAmount());
    }

    public boolean func_70315_b(int par1, int par2) {
        if (par1 == 1) {
            this.numUsingPlayers = par2;
            return true;
        }
        return super.func_70315_b(par1, par2);
    }

    public void func_70295_k_() {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, 1, this.numUsingPlayers);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, this.func_70311_o().field_71990_ca);
    }

    public void func_70305_f() {
        if (this.func_70311_o() != null && this.func_70311_o() instanceof GCCoreBlockParachest) {
            --this.numUsingPlayers;
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, 1, this.numUsingPlayers);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, this.func_70311_o().field_71990_ca);
        }
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return true;
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.func_70321_h();
    }

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }
}

