/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.List;
import micdoodle8.mods.galacticraft.api.item.IBreathableArmor;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemOxygenGear;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemOxygenMask;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemOxygenTank;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenDistributor;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class OxygenUtil {
    public static boolean shouldDisplayTankGui(GuiScreen gui) {
        if (FMLClientHandler.instance().getClient().field_71474_y.field_74319_N) {
            return false;
        }
        if (gui == null) {
            return true;
        }
        if (gui instanceof GuiInventory) {
            return false;
        }
        return gui instanceof GuiChat;
    }

    public static boolean isAABBInBreathableAirBlock(Entity entity) {
        return OxygenUtil.isAABBInBreathableAirBlock(entity.field_70170_p, new Vector3(entity.field_70121_D.field_72340_a - 1.0, entity.field_70121_D.field_72338_b - 1.0, entity.field_70121_D.field_72339_c - 1.0), new Vector3(entity.field_70121_D.field_72336_d + 1.0, entity.field_70121_D.field_72337_e + 1.0, entity.field_70121_D.field_72334_f + 1.0));
    }

    public static boolean isAABBInBreathableAirBlock(World world, Vector3 minVec, Vector3 maxVec) {
        double avgX = (minVec.x + maxVec.x) / 2.0;
        double avgY = (minVec.y + maxVec.y) / 2.0;
        double avgZ = (minVec.z + maxVec.z) / 2.0;
        List l = world.field_73009_h;
        for (Object o : l) {
            double dist;
            if (!(o instanceof GCCoreTileEntityOxygenDistributor)) continue;
            GCCoreTileEntityOxygenDistributor distributor = (GCCoreTileEntityOxygenDistributor)o;
            if (distributor.field_70331_k.field_72995_K || distributor.oxygenBubble == null || !((dist = distributor.getDistanceFromServer(avgX, avgY, avgZ)) < Math.pow(distributor.oxygenBubble.getSize(), 2.0))) continue;
            return true;
        }
        return OxygenUtil.isInOxygenBlock(world, AxisAlignedBB.func_72332_a().func_72299_a(minVec.x, minVec.y, minVec.z, maxVec.x, maxVec.y, maxVec.z).func_72331_e(0.001, 0.001, 0.001));
    }

    public static boolean isInOxygenBlock(World world, AxisAlignedBB bb) {
        int j1;
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(bb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(bb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        if (world.func_72904_c(i, k, i1, j, l, j1 = MathHelper.func_76128_c((double)(bb.field_72334_f + 1.0)))) {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        int j2 = world.func_72798_a(k1, l1, i2);
                        if (j2 != GCCoreBlocks.breatheableAir.field_71990_ca) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static int getDrainSpacing(ItemStack tank, ItemStack tank2) {
        boolean tank2Valid;
        boolean tank1Valid;
        boolean bl = tank != null ? tank.func_77973_b() instanceof GCCoreItemOxygenTank && tank.func_77958_k() - tank.func_77960_j() > 0 : (tank1Valid = false);
        boolean bl2 = tank2 != null ? tank2.func_77973_b() instanceof GCCoreItemOxygenTank && tank2.func_77958_k() - tank2.func_77960_j() > 0 : (tank2Valid = false);
        if (!tank1Valid && !tank2Valid) {
            return 0;
        }
        if (tank1Valid && !tank2Valid || !tank1Valid && tank2Valid) {
            return 9;
        }
        return 18;
    }

    public static boolean hasValidOxygenSetup(GCCorePlayerMP player) {
        IBreathableArmor breathableArmor;
        boolean handled;
        boolean missingComponent = false;
        if (player.getExtendedInventory().func_70301_a(0) == null || !OxygenUtil.isItemValidForPlayerTankInv(0, player.getExtendedInventory().func_70301_a(0))) {
            handled = false;
            for (ItemStack armorStack : player.field_71071_by.field_70460_b) {
                if (armorStack == null || !(armorStack.func_77973_b() instanceof IBreathableArmor) || !(breathableArmor = (IBreathableArmor)armorStack.func_77973_b()).handleGearType(IBreathableArmor.EnumGearType.HELMET) || !breathableArmor.canBreathe(armorStack, (EntityPlayer)player, IBreathableArmor.EnumGearType.HELMET)) continue;
                handled = true;
            }
            if (!handled) {
                missingComponent = true;
            }
        }
        if (player.getExtendedInventory().func_70301_a(1) == null || !OxygenUtil.isItemValidForPlayerTankInv(1, player.getExtendedInventory().func_70301_a(1))) {
            handled = false;
            for (ItemStack armorStack : player.field_71071_by.field_70460_b) {
                if (armorStack == null || !(armorStack.func_77973_b() instanceof IBreathableArmor) || !(breathableArmor = (IBreathableArmor)armorStack.func_77973_b()).handleGearType(IBreathableArmor.EnumGearType.GEAR) || !breathableArmor.canBreathe(armorStack, (EntityPlayer)player, IBreathableArmor.EnumGearType.GEAR)) continue;
                handled = true;
            }
            if (!handled) {
                missingComponent = true;
            }
        }
        if (!(player.getExtendedInventory().func_70301_a(2) != null && OxygenUtil.isItemValidForPlayerTankInv(2, player.getExtendedInventory().func_70301_a(2)) || player.getExtendedInventory().func_70301_a(3) != null && OxygenUtil.isItemValidForPlayerTankInv(3, player.getExtendedInventory().func_70301_a(3)))) {
            handled = false;
            for (ItemStack armorStack : player.field_71071_by.field_70460_b) {
                if (armorStack == null || !(armorStack.func_77973_b() instanceof IBreathableArmor)) continue;
                breathableArmor = (IBreathableArmor)armorStack.func_77973_b();
                if (breathableArmor.handleGearType(IBreathableArmor.EnumGearType.TANK1) && breathableArmor.canBreathe(armorStack, (EntityPlayer)player, IBreathableArmor.EnumGearType.TANK1)) {
                    handled = true;
                }
                if (!breathableArmor.handleGearType(IBreathableArmor.EnumGearType.TANK2) || !breathableArmor.canBreathe(armorStack, (EntityPlayer)player, IBreathableArmor.EnumGearType.TANK2)) continue;
                handled = true;
            }
            if (!handled) {
                missingComponent = true;
            }
        }
        return !missingComponent;
    }

    public static boolean isItemValidForPlayerTankInv(int slotIndex, ItemStack stack) {
        switch (slotIndex) {
            case 0: {
                return stack.func_77973_b() instanceof GCCoreItemOxygenMask;
            }
            case 1: {
                return stack.func_77973_b() instanceof GCCoreItemOxygenGear;
            }
            case 2: {
                return stack.func_77973_b() instanceof GCCoreItemOxygenTank;
            }
            case 3: {
                return stack.func_77973_b() instanceof GCCoreItemOxygenTank;
            }
        }
        return false;
    }
}

