/*
 * Decompiled with CFR 0.152.
 */
package src.train.client.gui.sideTabs;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;
import src.train.client.core.helpers.SessionHelper;
import src.train.client.gui.GuiTraincraft;
import src.train.client.gui.sideTabs.SideTab;
import src.train.common.Traincraft;

@SideOnly(value=Side.CLIENT)
public class SideTabManager {
    private GuiTraincraft gui;
    private Minecraft mc;
    protected ArrayList<SideTab> sideTabLeft = new ArrayList();
    protected ArrayList<SideTab> sideTabRight = new ArrayList();
    protected static FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;

    public SideTabManager(GuiTraincraft gui) {
        this.gui = gui;
        this.mc = Traincraft.proxy.getClientInstance();
    }

    public void add(SideTab tab) {
        if (tab.side) {
            this.sideTabLeft.add(tab);
            if (SessionHelper.getOpenedLedger() != null && tab.getClass().equals(SessionHelper.getOpenedLedger())) {
                tab.setFullyOpen();
            }
        } else {
            this.sideTabRight.add(tab);
            if (SessionHelper.getOpenedLedger() != null && tab.getClass().equals(SessionHelper.getOpenedLedger())) {
                tab.setFullyOpen();
            }
        }
    }

    public void insert(SideTab tab) {
        if (tab.side) {
            this.sideTabLeft.add(this.sideTabLeft.size() - 1, tab);
        } else {
            this.sideTabRight.add(this.sideTabRight.size() - 1, tab);
        }
    }

    public SideTab getAtPosition(int mX, int mY) {
        SideTab tab;
        int i;
        int xShift = (this.gui.field_73880_f - 176) / 2;
        int yShift = (this.gui.field_73881_g - 256) / 2 + 8;
        for (i = 0; i < this.sideTabLeft.size(); ++i) {
            tab = this.sideTabLeft.get(i);
            if (!tab.isVisible()) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.getHeight();
        }
        xShift = (this.gui.field_73880_f - 176) / 2 + 176;
        yShift = (this.gui.field_73881_g - 256) / 2 + 8;
        for (i = 0; i < this.sideTabRight.size(); ++i) {
            tab = this.sideTabRight.get(i);
            if (!tab.isVisible()) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.getHeight();
        }
        return null;
    }

    public void drawSideTabs(int mouseX, int mouseY) {
        int xPos = 8;
        for (SideTab tab : this.sideTabLeft) {
            tab.update();
            if (!tab.isVisible()) continue;
            tab.draw(-24, xPos);
            xPos += tab.getHeight();
        }
        xPos = 8;
        for (SideTab tab : this.sideTabRight) {
            tab.update();
            if (!tab.isVisible()) continue;
            tab.draw(176, xPos);
            xPos += tab.getHeight();
        }
        SideTab tab = this.getAtPosition(mouseX, mouseY);
        if (tab != null) {
            if (tab.side) {
                String tooltip = tab.getTooltip();
                int textWidth = fontRenderer.func_78256_a(tooltip);
                int startX = mouseX - (this.gui.field_73880_f - 176) / 2 - textWidth - 14;
                int startY = mouseY - (this.gui.field_73881_g - 256) / 2 - 12;
                int i4 = -267386864;
                int h = 8;
                int w = textWidth;
                this.gui.func_73733_a(startX - 3, startY - 4, startX + textWidth + 3, startY + 8 + 4, i4, i4);
                this.gui.func_73733_a(startX - 4, startY - 3, startX + textWidth + 4, startY + 8 + 3, i4, i4);
                int colour1 = 0x505000FF;
                int colour2 = (colour1 & 0xFEFEFE) >> 1 | colour1 & 0xFF000000;
                this.gui.func_73733_a(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, colour1, colour2);
                this.gui.func_73733_a(startX - 2, startY - 2, startX + textWidth + 2, startY + 8 + 2, i4, i4);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                fontRenderer.func_78261_a(tooltip, startX, startY, -1);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            } else {
                int startX = mouseX - (this.gui.field_73880_f - 176) / 2 + 12;
                int startY = mouseY - (this.gui.field_73881_g - 256) / 2 - 12;
                String tooltip = tab.getTooltip();
                int textWidth = fontRenderer.func_78256_a(tooltip);
                this.gui.func_73733_a(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, -1073741824, -1073741824);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                fontRenderer.func_78261_a(tooltip, startX, startY, -1);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
        }
    }

    public void handleMouseClicked(int x, int y, int mouseButton) {
        SideTab tab;
        if (mouseButton == 0 && (tab = this.getAtPosition(x, y)) != null) {
            if (tab.side) {
                if (!tab.handleMouseClicked(x, y, mouseButton)) {
                    for (SideTab other : this.sideTabLeft) {
                        if (other == tab || !other.isOpen()) continue;
                        other.toggleOpen();
                    }
                    tab.toggleOpen();
                }
            } else if (!tab.handleMouseClicked(x, y, mouseButton)) {
                for (SideTab other : this.sideTabRight) {
                    if (other == tab || !other.isOpen()) continue;
                    other.toggleOpen();
                }
                tab.toggleOpen();
            }
        }
    }

    public void handleMouseOver(SideTab tab) {
        block6: {
            block5: {
                if (!tab.side) break block5;
                if (tab == null) break block6;
                for (SideTab other : this.sideTabLeft) {
                    if (other != tab && other.isOpen()) {
                        other.toggleOpen();
                    }
                    tab.toggleOpen();
                }
                break block6;
            }
            if (tab != null) {
                for (SideTab other : this.sideTabRight) {
                    if (other != tab && other.isOpen()) {
                        other.toggleOpen();
                    }
                    tab.toggleOpen();
                }
            }
        }
    }
}

