/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import src.train.common.api.LiquidManager;
import src.train.common.api.Locomotive;

public abstract class DieselTrain
extends Locomotive
implements IFluidHandler {
    public int fuelSlot = 1;
    private int maxTank = 7000;
    private int update = 8;
    private LiquidManager.StandardTank theTank;
    private IFluidTank[] tankArray = new IFluidTank[1];
    private FluidStack liquid;

    public DieselTrain(World world, int liquidId, int quantity, int capacity) {
        this(new FluidStack(liquidId, quantity), capacity, world, null, null);
    }

    public DieselTrain(World world, int liquidId, int quantity, int capacity, FluidStack filter) {
        this(new FluidStack(liquidId, quantity), capacity, world, filter, null);
    }

    public DieselTrain(World world, int liquidId, int quantity, int capacity, FluidStack[] multiFilter) {
        this(new FluidStack(liquidId, quantity), capacity, world, null, multiFilter);
    }

    private DieselTrain(FluidStack liquid, int capacity, World world, FluidStack filter, FluidStack[] multiFilter) {
        super(world);
        this.liquid = liquid;
        this.maxTank = capacity;
        if (filter == null && multiFilter == null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = new LiquidManager.StandardTank(liquidManager, capacity);
        }
        if (filter != null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = new LiquidManager.FilteredTank(liquidManager, capacity, filter);
        }
        if (multiFilter != null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = new LiquidManager.FilteredTank(liquidManager, capacity, multiFilter);
        }
        this.tankArray[0] = this.theTank;
        this.field_70180_af.func_75682_a(4, (Object)new Integer(0));
        this.numCargoSlots = 3;
        this.numCargoSlots1 = 3;
        this.numCargoSlots2 = 3;
        this.inventorySize = this.numCargoSlots + this.numCargoSlots2 + this.numCargoSlots1 + this.fuelSlot;
        this.field_70180_af.func_75682_a(23, (Object)new Integer(0));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.theTank != null && this.theTank.getFluid() != null) {
            this.field_70180_af.func_75692_b(23, (Object)this.theTank.getFluid().amount);
            this.field_70180_af.func_75692_b(4, (Object)this.theTank.getFluid().fluidID);
            if (this.theTank.getFluid().amount <= 1) {
                this.field_70159_w *= 0.94;
                this.field_70179_y *= 0.94;
            }
        } else if (this.theTank != null && this.theTank.getFluid() == null) {
            this.field_70180_af.func_75692_b(23, (Object)0);
            this.field_70180_af.func_75692_b(4, (Object)0);
        }
    }

    public int getDiesel() {
        return this.field_70180_af.func_75679_c(23);
    }

    public int getLiquidItemID() {
        return this.field_70180_af.func_75679_c(4);
    }

    public LiquidManager.StandardTank getTank() {
        return this.theTank;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.theTank.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("canBeAdjusted", this.canBeAdjusted);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.theTank.readFromNBT(nbttagcompound);
        this.canBeAdjusted = nbttagcompound.func_74767_n("canBeAdjusted");
    }

    public int getCartTankCapacity() {
        return this.maxTank;
    }

    private void placeInInvent(ItemStack itemstack1) {
        for (int i = 1; i < this.locoInvent.length; ++i) {
            if (this.locoInvent[i] == null) {
                this.locoInvent[i] = itemstack1;
                return;
            }
            if (this.locoInvent[i] != null && this.locoInvent[i].field_77993_c == itemstack1.field_77993_c && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || this.locoInvent[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)this.locoInvent[i], (ItemStack)itemstack1)) {
                int var9 = this.locoInvent[i].field_77994_a + itemstack1.field_77994_a;
                if (var9 <= itemstack1.func_77976_d()) {
                    this.locoInvent[i].field_77994_a = var9;
                } else if (this.locoInvent[i].field_77994_a < itemstack1.func_77976_d()) {
                    ++this.locoInvent[i].field_77994_a;
                }
                return;
            }
            if (i != this.locoInvent.length - 1) continue;
            this.func_70054_a(itemstack1.func_77973_b().field_77779_bT, 1, 0.0f);
            return;
        }
    }

    public void liquidInSlot(ItemStack itemstack) {
        ItemStack result;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ++this.update;
        if (this.update % 8 == 0 && itemstack != null && (result = LiquidManager.getInstance().processContainer(this, 0, this.theTank, itemstack, 0)) != null) {
            this.placeInInvent(result);
            this.func_70298_a(0, 1);
        }
    }

    protected ItemStack checkInvent(ItemStack locoInvent0) {
        if (!this.canCheckInvent) {
            return locoInvent0;
        }
        ItemStack ret = locoInvent0;
        if (this.getDiesel() > 0) {
            this.fuelTrain = this.getDiesel();
        }
        if (this.fuelTrain <= 0) {
            this.field_70159_w *= 0.88;
            this.field_70179_y *= 0.88;
        }
        if (locoInvent0 != null) {
            this.liquidInSlot(locoInvent0);
        }
        return locoInvent0;
    }

    public void setLiquid(FluidStack liquid) {
        this.liquid = liquid;
    }

    public void setCapacity(int capacity) {
        this.maxTank = capacity;
    }

    public int getCapacity() {
        return this.maxTank;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.theTank.getFluid())) {
            return null;
        }
        return this.theTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.theTank.getInfo()};
    }

    public FluidStack getFluid() {
        return this.theTank.getFluid();
    }

    public int getFluidAmount() {
        return this.theTank.getFluidAmount();
    }
}

