/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import buildcraft.api.fuels.IronEngineFuel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.fuel.FuelManager;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import src.train.common.Traincraft;
import src.train.common.blocks.BlockTraincraftFluid;
import src.train.common.items.ItemBlockFluid;
import src.train.common.library.BlockIDs;
import src.train.common.library.ItemIDs;

public class LiquidManager {
    public static final int BUCKET_VOLUME = 1000;
    private static LiquidManager instance;
    public static FluidStack WATER_FILTER;
    public static FluidStack LAVA_FILTER;
    public static Fluid oil;
    public static Fluid steam;
    public static Fluid fuel;
    public static Fluid creosoteOil;
    public static Fluid biomass;
    public static Fluid biofuel;
    public static Fluid seedoil;
    public static Fluid honey;
    public static Fluid juice;
    public static final Fluid DIESEL;
    public static final Fluid REFINED_FUEL;

    public static LiquidManager getInstance() {
        if (instance == null) {
            instance = new LiquidManager();
        }
        return instance;
    }

    public void registerLiquids() {
        FluidRegistry.registerFluid((Fluid)DIESEL);
        FluidRegistry.registerFluid((Fluid)REFINED_FUEL);
        BlockIDs.diesel.block = new BlockTraincraftFluid(BlockIDs.diesel.blockID, DIESEL, Material.field_76244_g).setFlammable(true).setFlammability(5);
        DIESEL.setBlockID(BlockIDs.diesel.block);
        BlockIDs.refinedFuel.block = new BlockTraincraftFluid(BlockIDs.refinedFuel.blockID, REFINED_FUEL, Material.field_76244_g).setFlammable(true).setFlammability(4);
        REFINED_FUEL.setBlockID(BlockIDs.refinedFuel.block);
        FluidContainerRegistry.registerFluidContainer((Fluid)DIESEL, (ItemStack)new ItemStack(ItemIDs.diesel.item), (ItemStack)new ItemStack(ItemIDs.emptyCanister.item));
        FluidContainerRegistry.registerFluidContainer((Fluid)REFINED_FUEL, (ItemStack)new ItemStack(ItemIDs.refinedFuel.item), (ItemStack)new ItemStack(ItemIDs.emptyCanister.item));
        LiquidManager.dieselFilter();
        FuelManager.addBoilerFuel(DIESEL, 60000);
        FuelManager.addBoilerFuel(REFINED_FUEL, 96000);
        IronEngineFuel.addFuel(DIESEL, 3.0f, 200000);
        IronEngineFuel.addFuel(REFINED_FUEL, 6.0f, 100000);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Traincraft.proxy.registerBlock(BlockIDs.diesel.block, ItemBlockFluid.class);
        Traincraft.proxy.registerBlock(BlockIDs.refinedFuel.block, ItemBlockFluid.class);
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        if (event.map.field_94255_a == 0) {
            DIESEL.setIcons(BlockIDs.diesel.block.func_71851_a(1), BlockIDs.diesel.block.func_71851_a(2));
            REFINED_FUEL.setIcons(BlockIDs.refinedFuel.block.func_71851_a(1), BlockIDs.refinedFuel.block.func_71851_a(2));
        }
    }

    public static void getLiquidsFromDictionnary() {
        oil = FluidRegistry.getFluid((String)"oil");
        steam = FluidRegistry.getFluid((String)"steam");
        fuel = FluidRegistry.getFluid((String)"fuel");
        creosoteOil = FluidRegistry.getFluid((String)"creosote oil");
        biomass = FluidRegistry.getFluid((String)"biomass");
        biofuel = FluidRegistry.getFluid((String)"bioethanol");
        seedoil = FluidRegistry.getFluid((String)"seedoil");
        honey = FluidRegistry.getFluid((String)"honey");
        juice = FluidRegistry.getFluid((String)"juice");
    }

    public boolean isDieselLocoFuel(ItemStack stack) {
        FluidStack bucketLiquid = this.getFluidInContainer(stack);
        LiquidManager.getInstance();
        FluidStack[] multiFilter = LiquidManager.dieselFilter();
        if (multiFilter != null) {
            for (int i = 0; i < multiFilter.length; ++i) {
                if (multiFilter[i] != null && bucketLiquid != null && multiFilter[i].isFluidEqual(bucketLiquid)) {
                    return true;
                }
                if (!this.isEmptyContainer(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static FluidStack[] dieselFilter() {
        FluidStack[] fuels = new FluidStack[4];
        if (DIESEL != null) {
            fuels[0] = new FluidStack(DIESEL, 1);
        }
        if (REFINED_FUEL != null) {
            fuels[1] = new FluidStack(REFINED_FUEL, 1);
        }
        if (biofuel != null) {
            fuels[2] = new FluidStack(biofuel, 1);
        }
        if (fuel != null) {
            fuels[3] = new FluidStack(fuel, 1);
        }
        return fuels;
    }

    public boolean isBucket(ItemStack stack) {
        return FluidContainerRegistry.isBucket((ItemStack)stack);
    }

    public boolean isContainer(ItemStack stack) {
        return FluidContainerRegistry.isContainer((ItemStack)stack);
    }

    public boolean isFilledContainer(ItemStack stack) {
        return FluidContainerRegistry.isFilledContainer((ItemStack)stack);
    }

    public boolean isEmptyContainer(ItemStack stack) {
        return FluidContainerRegistry.isEmptyContainer((ItemStack)stack);
    }

    public ItemStack fillFluidContainer(FluidStack liquid, ItemStack empty) {
        if (liquid == null || empty == null) {
            return null;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)empty);
    }

    public FluidStack getFluidInContainer(ItemStack stack) {
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
    }

    public boolean containsFluid(ItemStack stack, FluidStack liquid) {
        return FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)liquid);
    }

    public boolean isFluidEqual(FluidStack L1, FluidStack L2) {
        if (L1 == null || L2 == null) {
            return false;
        }
        return L1.isFluidEqual(L2);
    }

    public ItemStack processContainer(IInventory inventory, IFluidTank tank, ItemStack itemstack, int tankIndex) {
        ItemStack filled;
        FluidStack bucketLiquid = this.getFluidInContainer(itemstack);
        ItemStack emptyItem = itemstack.func_77973_b().getContainerItemStack(itemstack);
        if (bucketLiquid != null && emptyItem == null) {
            int used = tank.fill(bucketLiquid, false);
            if (used >= bucketLiquid.amount) {
                tank.fill(bucketLiquid, true);
                inventory.func_70298_a(0, 1);
                return emptyItem;
            }
        } else if (LiquidManager.getInstance().isEmptyContainer(itemstack) && (filled = LiquidManager.getInstance().fillFluidContainer(tank.getFluid(), itemstack)) != null) {
            FluidStack liquid = this.getFluidInContainer(filled);
            FluidStack drain = tank.drain(liquid.amount, false);
            if (drain != null && drain.amount > 0) {
                tank.drain(liquid.amount, true);
                inventory.func_70298_a(0, 1);
                return filled;
            }
        }
        return null;
    }

    public ItemStack processContainer(IInventory inventory, int inventoryIndex, StandardTank tank, ItemStack itemstack, int tankIndex) {
        ItemStack filled;
        FluidStack bucketLiquid = this.getFluidInContainer(itemstack);
        ItemStack emptyItem = itemstack.func_77973_b().getContainerItemStack(itemstack);
        if (bucketLiquid != null) {
            int used = tank.fill(bucketLiquid, false);
            if (used >= bucketLiquid.amount) {
                tank.fill(bucketLiquid, true);
                inventory.func_70298_a(inventoryIndex, 1);
                return emptyItem;
            }
        } else if (LiquidManager.getInstance().isEmptyContainer(itemstack) && (filled = LiquidManager.getInstance().fillFluidContainer(tank.getFluid(), itemstack)) != null) {
            FluidStack liquid = this.getFluidInContainer(filled);
            FluidStack drain = tank.drain(liquid.amount, false);
            if (drain != null && drain.amount > 0) {
                tank.drain(liquid.amount, true);
                inventory.func_70298_a(inventoryIndex, 1);
                return filled;
            }
        }
        return null;
    }

    static {
        WATER_FILTER = new FluidStack(FluidRegistry.WATER, 1);
        LAVA_FILTER = new FluidStack(FluidRegistry.LAVA, 1);
        DIESEL = new Fluid("Diesel").setUnlocalizedName("diesel.name").setDensity(860);
        REFINED_FUEL = new Fluid("RefinedFuel").setDensity(820).setUnlocalizedName("refinedfuel.name");
    }

    public class ReverseFilteredTank
    extends StandardTank {
        private final FluidStack filter;
        private final FluidStack[] multiFilter;

        public ReverseFilteredTank(int capacity, FluidStack filter) {
            super(capacity);
            this.filter = filter;
            this.multiFilter = null;
        }

        public ReverseFilteredTank(int capacity, FluidStack filter, int pressure) {
            this(capacity, filter);
        }

        public ReverseFilteredTank(int capacity, FluidStack[] filter) {
            super(capacity);
            this.multiFilter = filter;
            this.filter = null;
        }

        public ReverseFilteredTank(int capacity, FluidStack[] filter, int pressure) {
            this(capacity, filter);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.multiFilter != null) {
                for (int i = 0; i < this.multiFilter.length; ++i) {
                    if (this.multiFilter[i] == null || resource.fluidID == this.multiFilter[i].fluidID) continue;
                    return super.fill(resource, doFill);
                }
            } else if (this.filter.fluidID != resource.fluidID) {
                return super.fill(resource, doFill);
            }
            return 0;
        }

        public FluidStack getFilter() {
            return this.filter.copy();
        }

        public boolean liquidMatchesFilter(FluidStack resource) {
            if (resource == null || this.filter == null) {
                return false;
            }
            return this.filter.isFluidEqual(resource);
        }
    }

    public class FilteredTank
    extends StandardTank {
        private final FluidStack filter;
        private final FluidStack[] multiFilter;

        public FilteredTank(int capacity, FluidStack filter) {
            super(capacity);
            this.filter = filter;
            this.multiFilter = null;
        }

        public FilteredTank(int capacity, FluidStack filter, int pressure) {
            this(capacity, filter);
        }

        public FilteredTank(int capacity, FluidStack[] filter) {
            super(capacity);
            this.multiFilter = filter;
            this.filter = null;
        }

        public FilteredTank(int capacity, FluidStack[] filter, int pressure) {
            this(capacity, filter);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.multiFilter != null) {
                for (int i = 0; i < this.multiFilter.length; ++i) {
                    if (this.multiFilter[i] == null || !LiquidManager.this.isFluidEqual(this.multiFilter[i], resource)) continue;
                    return super.fill(resource, doFill);
                }
            } else if (this.filter.isFluidEqual(resource)) {
                return super.fill(resource, doFill);
            }
            return 0;
        }

        public FluidStack getFilter() {
            return this.filter.copy();
        }

        public boolean liquidMatchesFilter(FluidStack resource) {
            if (resource == null || this.filter == null) {
                return false;
            }
            return this.filter.isFluidEqual(resource);
        }
    }

    public class StandardTank
    extends FluidTank {
        private int tankIndex;

        public StandardTank(int capacity) {
            super(capacity);
        }

        public void setTankIndex(int index) {
            this.tankIndex = index;
        }

        public int getTankIndex() {
            return this.tankIndex;
        }

        public boolean isEmpty() {
            return this.getFluid() == null || this.getFluid().amount <= 0;
        }
    }
}

