/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import buildcraft.api.inventory.ISpecialInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import src.train.common.api.EntityRollingStock;
import src.train.common.api.LiquidManager;

public class LiquidTank
extends EntityRollingStock
implements IFluidHandler,
ISpecialInventory {
    private FluidStack liquid;
    private int capacity;
    protected ItemStack[] cargoItems;
    private int update = 8;
    private LiquidManager.StandardTank theTank;
    private IFluidTank[] tankArray = new IFluidTank[1];

    public LiquidTank(World world, int liquidId, int quantity, int capacity) {
        this(new FluidStack(liquidId, quantity), capacity, world, null, false);
    }

    public LiquidTank(World world, int liquidId, int quantity, int capacity, FluidStack filter) {
        this(new FluidStack(liquidId, quantity), capacity, world, filter, false);
    }

    public LiquidTank(World world, int liquidId, int quantity, int capacity, FluidStack filter, boolean reverseSort) {
        this(new FluidStack(liquidId, quantity), capacity, world, filter, reverseSort);
    }

    private LiquidTank(FluidStack liquid, int capacity, World world, FluidStack filter, boolean reverseSort) {
        super(world);
        this.liquid = liquid;
        this.capacity = capacity;
        if (filter == null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.StandardTank(capacity);
        }
        if (filter != null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.FilteredTank(capacity, filter);
        }
        if (filter != null && reverseSort) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.ReverseFilteredTank(capacity, filter);
        }
        this.tankArray[0] = this.theTank;
        this.field_70180_af.func_75682_a(4, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(22, (Object)new String(""));
    }

    public int getAmount() {
        return this.field_70180_af.func_75679_c(18);
    }

    public int getLiquidItemID() {
        return this.field_70180_af.func_75679_c(4);
    }

    public String getLiquidName() {
        return this.field_70180_af.func_75681_e(22);
    }

    public LiquidManager.StandardTank getTank() {
        return this.theTank;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.theTank.writeToNBT(nbttagcompound);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.theTank.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.theTank != null && this.theTank.getFluid() != null) {
            this.field_70180_af.func_75692_b(18, (Object)this.theTank.getFluid().amount);
            this.field_70180_af.func_75692_b(4, (Object)this.theTank.getFluid().fluidID);
            if (this.theTank.getFluid().getFluid() != null) {
                this.field_70180_af.func_75692_b(22, (Object)this.theTank.getFluid().getFluid().getName());
            }
            this.handleMass();
        } else if (this.theTank != null && this.theTank.getFluid() == null) {
            this.field_70180_af.func_75692_b(18, (Object)0);
            this.field_70180_af.func_75692_b(4, (Object)0);
            this.field_70180_af.func_75692_b(22, (Object)"");
        }
    }

    protected void handleMass() {
        if (this.updateTicks % 10 != 0 && this.theTank.getFluid().amount > 0) {
            this.mass = this.getDefaultMass();
            double preciseAmount = this.theTank.getFluid().amount;
            this.mass += preciseAmount / 10000.0;
        }
    }

    public ItemStack checkInvent(ItemStack itemstack) {
        ItemStack result = null;
        if (this.field_70170_p.field_72995_K) {
            return itemstack;
        }
        ++this.update;
        if (this.update % 8 == 0 && itemstack != null) {
            ItemStack emptyItem = itemstack.func_77973_b().getContainerItemStack(itemstack);
            if (this.cargoItems[1] == null) {
                result = LiquidManager.getInstance().processContainer(this, 0, this.theTank, itemstack, 0);
            } else if (emptyItem != null) {
                if (this.cargoItems[1] != null && emptyItem.func_77973_b().field_77779_bT == this.cargoItems[1].field_77993_c && this.cargoItems[1].field_77994_a + 1 < this.cargoItems[1].func_77976_d()) {
                    result = LiquidManager.getInstance().processContainer(this, 0, this.theTank, itemstack, 0);
                }
            } else if (this.cargoItems[1] != null && itemstack.func_77973_b().field_77779_bT == this.cargoItems[1].field_77993_c && this.cargoItems[1].field_77994_a + 1 <= this.cargoItems[1].func_77976_d()) {
                result = LiquidManager.getInstance().processContainer(this, 0, this.theTank, itemstack, 0);
            }
            if (result != null) {
                if (this.cargoItems[1] == null) {
                    this.cargoItems[1] = result;
                } else if (this.cargoItems[1].func_77973_b().field_77779_bT == result.field_77993_c) {
                    ++this.cargoItems[1].field_77994_a;
                }
            }
        }
        return itemstack;
    }

    public void setLiquid(FluidStack liquid) {
        this.liquid = liquid;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    private int placeInSpecialInvent(ItemStack itemstack1, int i, boolean doAdd) {
        if (this.cargoItems[i] == null) {
            if (doAdd) {
                this.cargoItems[i] = itemstack1;
            }
            return itemstack1.field_77994_a;
        }
        if (this.cargoItems[i] != null && this.cargoItems[i].field_77993_c == itemstack1.field_77993_c && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || this.cargoItems[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)this.cargoItems[i], (ItemStack)itemstack1)) {
            int var9 = this.cargoItems[i].field_77994_a + itemstack1.field_77994_a;
            if (var9 <= itemstack1.func_77976_d()) {
                if (doAdd) {
                    this.cargoItems[i].field_77994_a = var9;
                }
                return var9;
            }
            if (this.cargoItems[i].field_77994_a < itemstack1.func_77976_d()) {
                if (doAdd) {
                    this.cargoItems[i].field_77994_a = this.cargoItems[i].func_77976_d();
                }
                return Math.abs(this.cargoItems[i].func_77976_d() - this.cargoItems[i].field_77994_a - itemstack1.field_77994_a);
            }
        }
        return itemstack1.field_77994_a;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (stack == null) {
            return 0;
        }
        if (LiquidManager.getInstance().isContainer(stack)) {
            return this.placeInSpecialInvent(stack, 0, doAdd);
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return null;
    }

    public ItemStack func_70301_a(int i) {
        return this.cargoItems[i];
    }

    public ItemStack func_70304_b(int par1) {
        if (this.cargoItems[par1] != null) {
            ItemStack var2 = this.cargoItems[par1];
            this.cargoItems[par1] = null;
            return var2;
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.cargoItems[i] != null) {
            if (this.cargoItems[i].field_77994_a <= j) {
                ItemStack itemstack = this.cargoItems[i];
                this.cargoItems[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.cargoItems[i].func_77979_a(j);
            if (this.cargoItems[i].field_77994_a == 0) {
                this.cargoItems[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.cargoItems[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return null;
    }

    public void func_70296_d() {
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.cargoItems.length;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.canBeDestroyedByPlayer(damagesource)) {
            return true;
        }
        super.func_70097_a(damagesource, i);
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + i * 10.0f);
        if (this.func_70491_i() > 40.0f) {
            boolean flag;
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
            boolean bl = flag = damagesource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d;
            if (!flag) {
                this.dropCartAsItem();
            }
        }
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public FluidStack getFluid() {
        return this.theTank.getFluid();
    }

    public int getFluidAmount() {
        return this.theTank.getFluidAmount();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.theTank.getFluid())) {
            return null;
        }
        return this.theTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.theTank.getInfo()};
    }
}

