/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import src.train.common.api.LiquidManager;
import src.train.common.api.Locomotive;
import src.train.common.api.Tender;
import src.train.common.core.handlers.FuelHandler;

public abstract class SteamTrain
extends Locomotive
implements IFluidHandler {
    protected int waterConsumption = 200;
    public int fuelSlot = 1;
    public int waterSlot = 1;
    protected int maxTank;
    private int maxFuel = 20000;
    private int update = 8;
    private LiquidManager.StandardTank theTank;
    private IFluidTank[] tankArray = new IFluidTank[1];
    private FluidStack liquid;

    public SteamTrain(World world, int liquidId, int quantity, int capacity) {
        this(new FluidStack(liquidId, quantity), capacity, world, null);
    }

    public SteamTrain(World world, int liquidId, int quantity, int capacity, FluidStack filter) {
        this(new FluidStack(liquidId, quantity), capacity, world, filter);
    }

    private SteamTrain(FluidStack liquid, int capacity, World world, FluidStack filter) {
        super(world);
        this.liquid = liquid;
        this.maxTank = capacity;
        if (filter == null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.StandardTank(capacity);
        }
        if (filter != null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.FilteredTank(capacity, filter);
        }
        this.tankArray[0] = this.theTank;
        this.field_70180_af.func_75682_a(4, (Object)new Integer(0));
        this.numCargoSlots = 3;
        this.numCargoSlots1 = 3;
        this.numCargoSlots2 = 3;
        this.inventorySize = this.numCargoSlots + this.numCargoSlots2 + this.numCargoSlots1 + this.fuelSlot + this.waterSlot;
        this.field_70180_af.func_75682_a(23, (Object)new Integer(0));
    }

    public int getWaterConsumption() {
        if (this.trainSpec != null) {
            return this.trainSpec.getWaterConsumption();
        }
        return 200;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.theTank != null && this.theTank.getFluid() != null) {
            this.field_70180_af.func_75692_b(23, (Object)this.theTank.getFluid().amount);
            this.field_70180_af.func_75692_b(4, (Object)this.theTank.getFluid().fluidID);
            if (this.theTank.getFluid().amount <= 1) {
                this.field_70159_w *= 0.94;
                this.field_70179_y *= 0.94;
            }
        } else if (this.theTank != null && this.theTank.getFluid() == null) {
            this.field_70180_af.func_75692_b(23, (Object)0);
            this.field_70180_af.func_75692_b(4, (Object)0);
        }
        if (this.field_70146_Z.nextInt(this.getWaterConsumption()) == 0 && this.getWater() > 0) {
            this.drain(ForgeDirection.UNKNOWN, 1, true);
        }
    }

    public int getWater() {
        return this.field_70180_af.func_75679_c(23);
    }

    public int getLiquidItemID() {
        return this.field_70180_af.func_75679_c(4);
    }

    public LiquidManager.StandardTank getTank() {
        return this.theTank;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.theTank.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("canBeAdjusted", this.canBeAdjusted);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.theTank.readFromNBT(nbttagcompound);
        this.canBeAdjusted = nbttagcompound.func_74767_n("canBeAdjusted");
    }

    public int getCartTankCapacity() {
        return this.maxTank;
    }

    private void placeInInvent(ItemStack itemstack1, SteamTrain loco) {
        for (int i = 2; i < loco.locoInvent.length; ++i) {
            if (loco.locoInvent[i] == null) {
                loco.locoInvent[i] = itemstack1;
                return;
            }
            if (loco.locoInvent[i] != null && loco.locoInvent[i].field_77993_c == itemstack1.field_77993_c && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || this.locoInvent[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)this.locoInvent[i], (ItemStack)itemstack1)) {
                int var9 = this.locoInvent[i].field_77994_a + itemstack1.field_77994_a;
                if (var9 <= itemstack1.func_77976_d()) {
                    loco.locoInvent[i].field_77994_a = var9;
                } else if (this.locoInvent[i].field_77994_a < itemstack1.func_77976_d()) {
                    ++loco.locoInvent[i].field_77994_a;
                }
                return;
            }
            if (i != loco.locoInvent.length - 1) continue;
            this.func_70054_a(itemstack1.func_77973_b().field_77779_bT, 1, 0.0f);
            return;
        }
    }

    public void liquidInSlot(ItemStack itemstack, SteamTrain loco) {
        ItemStack result;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ++this.update;
        if (this.update % 8 == 0 && itemstack != null && (result = LiquidManager.getInstance().processContainer(this, 1, this.theTank, itemstack, 0)) != null) {
            this.placeInInvent(result, loco);
            this.func_70298_a(1, 1);
        }
    }

    protected void checkInvent(ItemStack locoInvent0, ItemStack locoInvent1, SteamTrain loco) {
        if (!this.canCheckInvent) {
            return;
        }
        boolean hasCoalInTender = false;
        AxisAlignedBB box3 = null;
        box3 = loco.field_70177_z == -90.0f || loco.field_70177_z == 90.0f ? loco.field_70121_D.func_72314_b(2.4, 2.1, 2.7) : (loco.field_70177_z == 180.0f || loco.field_70177_z == 0.0f ? loco.field_70121_D.func_72314_b(2.7, 2.1, 2.4) : loco.field_70121_D.func_72314_b(1.5, 2.1, 1.5));
        List lis3 = this.field_70170_p.func_72839_b((Entity)this, box3);
        if (lis3 != null && lis3.size() > 0) {
            for (int j1 = 0; j1 < lis3.size(); ++j1) {
                Entity entity = (Entity)lis3.get(j1);
                if (entity instanceof Tender && (this.isAttached || this.isLinked())) {
                    for (int h = 0; h < ((Tender)entity).tenderItems.length; ++h) {
                        if (((Tender)entity).tenderItems[h] != null && FuelHandler.steamFuelLast(((Tender)entity).tenderItems[h]) != 0) {
                            if (this.getFuel() >= this.maxFuel || this.getFuel() + FuelHandler.steamFuelLast(((Tender)entity).tenderItems[h]) > this.maxFuel) continue;
                            this.fuelTrain += FuelHandler.steamFuelLast(((Tender)entity).tenderItems[h]);
                            hasCoalInTender = true;
                            ((Tender)entity).func_70298_a(h, 1);
                            return;
                        }
                        if (((Tender)entity).getWater() <= 0 || this.getWater() >= this.maxTank) continue;
                        FluidStack drain = ((Tender)entity).drain(ForgeDirection.UNKNOWN, 1, false);
                        if (drain != null && drain.amount > 0) {
                            ((Tender)entity).drain(ForgeDirection.UNKNOWN, 1, true);
                        }
                        int used = this.fill(ForgeDirection.UNKNOWN, drain, false);
                        if (drain == null || used < drain.amount) continue;
                        this.fill(ForgeDirection.UNKNOWN, drain, true);
                    }
                    continue;
                }
                hasCoalInTender = false;
            }
        }
        if (!hasCoalInTender && locoInvent0 != null && FuelHandler.steamFuelLast(locoInvent0) != 0 && this.getFuel() < this.maxFuel && this.getFuel() + FuelHandler.steamFuelLast(locoInvent0) <= this.maxFuel) {
            this.fuelTrain += FuelHandler.steamFuelLast(locoInvent0);
            this.func_70298_a(0, 1);
        }
        if (locoInvent1 != null) {
            this.liquidInSlot(locoInvent1, loco);
            return;
        }
        if (this.getFuel() <= 0) {
            this.field_70159_w *= 0.88;
            this.field_70179_y *= 0.88;
        }
    }

    @Override
    public int getFuelDiv(int i) {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24) * i / this.maxFuel;
        }
        return this.fuelTrain * i / this.maxFuel;
    }

    public void setLiquid(FluidStack liquid) {
        this.liquid = liquid;
    }

    public void setCapacity(int capacity) {
        this.maxTank = capacity;
    }

    public int getCapacity() {
        return this.maxTank;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.theTank.getFluid())) {
            return null;
        }
        return this.theTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.theTank.getInfo()};
    }

    public FluidStack getFluid() {
        return this.theTank.getFluid();
    }

    public int getFluidAmount() {
        return this.theTank.getFluidAmount();
    }
}

