/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.api.tracks.ITrackPowered;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import src.train.common.api.AbstractTrains;
import src.train.common.api.Locomotive;
import src.train.common.blocks.tracks.BlockTrackLockingBase;
import src.train.common.library.TrackIDs;

public class BlockStationTrack
extends BlockTrackLockingBase
implements ITrackLockdown,
ITrackPowered {
    protected static float DIR_THRESHOLD = 0.01f;
    protected boolean launchForward = true;
    protected byte reset = 0;
    private int updateTicks = 0;
    private boolean activated = false;
    private int delayTime = 100;
    private int activateRate = 300;
    private int mode = 0;

    @Override
    public Icon getIcon() {
        if (this.delay > 0) {
            return this.getIcon(4 + this.mode);
        }
        return this.getIcon(0 + this.mode);
    }

    @Override
    public TrackIDs getTrackType() {
        return TrackIDs.STATION_TRACK;
    }

    @Override
    public void updateEntity() {
        if (this.getCurrentCart() != null && this.getCurrentCart().func_70089_S()) {
            this.setCurrentCart(null);
        }
        if (!this.getWorld().field_72995_K) {
            if (this.updateTicks >= this.getActivateRate()) {
                if (this.isPowered()) {
                    this.activated = true;
                    this.delay = this.getDelayTime();
                }
                this.updateTicks = 0;
                this.sendUpdateToClient();
            } else if (this.delay <= 0) {
                this.activated = false;
                this.sendUpdateToClient();
            }
            if (this.delay > 0) {
                --this.delay;
                if (this.delay == 0) {
                    this.setCurrentCart(null);
                }
            }
            if (this.reset > 0) {
                this.reset = (byte)(this.reset - 1);
            }
        }
        this.prevDelay = this.delay;
        ++this.updateTicks;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        if (this.getWorld().field_72995_K) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.func_77973_b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            ++this.mode;
            if (this.mode > 3) {
                this.mode = 0;
            }
            if (this.mode == 0) {
                player.func_71035_c("Activated every 15s for 5s");
                this.delayTime = 100;
                this.activateRate = 300;
            }
            if (this.mode == 1) {
                player.func_71035_c("Activated every 30s for 15s");
                this.delayTime = 300;
                this.activateRate = 600;
            }
            if (this.mode == 2) {
                player.func_71035_c("Activated every minute for 30s");
                this.delayTime = 600;
                this.activateRate = 1200;
            }
            if (this.mode == 3) {
                player.func_71035_c("Activated every five minutes for 30s");
                this.delayTime = 600;
                this.activateRate = 6000;
            }
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            this.sendUpdateToClient();
            return true;
        }
        return false;
    }

    @Override
    protected void checkCart(EntityMinecart cart) {
        if (this.delay > 0 && (cart != this.getCurrentCart() || this.reset == 0)) {
            this.setCurrentCart(cart);
            this.setLaunchDirection(cart);
        }
        this.reset = (byte)10;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (cart instanceof Locomotive || !(cart instanceof AbstractTrains) && cart instanceof EntityMinecart) {
            this.checkCart(cart);
            int meta = this.tileEntity.func_70322_n();
            if (this.delay > 0) {
                this.releaseCart(cart);
                double boostX = Math.abs(this.prevSpeedX);
                double boostZ = Math.abs(this.prevSpeedZ);
                this.prevSpeedX = 0.0;
                this.prevSpeedZ = 0.0;
                if (meta == 0 || meta == 4 || meta == 5) {
                    if (boostZ != 0.0) {
                        cart.field_70179_y = this.launchForward ? boostZ : -boostZ;
                    }
                } else if ((meta == 1 || meta == 2 || meta == 3) && boostX != 0.0) {
                    cart.field_70159_w = this.launchForward ? boostX : -boostX;
                }
            } else {
                if (this.getCurrentCart() == null) {
                    this.setCurrentCart(cart);
                    this.setLaunchDirection(cart);
                }
                if (this.getCurrentCart() == cart) {
                    this.lockCart(cart);
                    cart.field_70159_w = 0.0;
                    cart.field_70179_y = 0.0;
                    if (meta == 0 || meta == 4 || meta == 5) {
                        cart.func_70107_b(cart.field_70165_t, cart.field_70163_u, (double)this.tileEntity.field_70327_n + 0.5);
                    } else {
                        cart.func_70107_b((double)this.tileEntity.field_70329_l + 0.5, cart.field_70163_u, cart.field_70161_v);
                    }
                }
            }
        }
    }

    @Override
    protected int getDelayTime() {
        return this.delayTime;
    }

    protected int getActivateRate() {
        return this.activateRate;
    }

    protected void setLaunchDirection(EntityMinecart cart) {
        int meta = this.tileEntity.func_70322_n();
        double speed = CartTools.getCartSpeedUncapped(cart);
        if (speed > (double)DIR_THRESHOLD) {
            boolean launch = this.launchForward;
            if (meta == 0 || meta == 4 || meta == 5) {
                launch = cart.field_70179_y > 0.0;
            } else if (meta == 1 || meta == 2 || meta == 3) {
                boolean bl = launch = cart.field_70159_w > 0.0;
            }
            if (this.launchForward != launch) {
                this.launchForward = launch;
                this.sendUpdateToClient();
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("launchForward", this.launchForward);
        data.func_74768_a("activateRate", this.activateRate);
        data.func_74768_a("delayTime", this.delayTime);
        data.func_74768_a("mode", this.mode);
        data.func_74768_a("ticks", this.updateTicks);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.launchForward = data.func_74767_n("launchForward");
        this.activateRate = data.func_74762_e("activateRate");
        this.delayTime = data.func_74762_e("delayTime");
        this.mode = data.func_74762_e("mode");
        this.updateTicks = data.func_74762_e("ticks");
        this.sendUpdateToClient();
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.launchForward);
        data.writeInt(this.mode);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.launchForward = data.readBoolean();
        this.mode = data.readInt();
        this.markBlockNeedsUpdate();
    }
}

