/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.core.handlers;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import src.train.common.api.AbstractTrains;
import src.train.common.api.EntityRollingStock;
import src.train.common.api.Locomotive;
import src.train.common.core.handlers.RollingStockStatsEventHandler;
import src.train.common.core.handlers.ServerTickHandler;
import src.train.common.entity.rollingStock.EntityJukeBoxCart;
import src.train.common.entity.rollingStock.EntityTracksBuilder;
import src.train.common.entity.zeppelin.AbstractZeppelin;
import src.train.common.items.ItemRecipeBook;
import src.train.common.tile.TileBook;
import src.train.common.tile.TileCrafterTierI;
import src.train.common.tile.TileCrafterTierII;
import src.train.common.tile.TileCrafterTierIII;
import src.train.common.tile.TileEntityDistil;
import src.train.common.tile.TileEntityOpenHearthFurnace;
import src.train.common.tile.TileGeneratorDiesel;
import src.train.common.tile.TileLantern;
import src.train.common.tile.TileSignal;
import src.train.common.tile.TileStopper;
import src.train.common.tile.TileTrainWbench;
import src.train.common.tile.TileWaterWheel;
import src.train.common.tile.TileWindMill;

public class PacketHandler
implements IPacketHandler {
    protected RollingStockStatsEventHandler statsEventHandler = new RollingStockStatsEventHandler();

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.field_73629_c);
        int packetIndex = data.readInt();
        World world = ((EntityPlayer)player).field_70170_p;
        if (packetIndex == 0) {
            byte orientation;
            int z;
            int y;
            int x = data.readInt();
            TileEntity te = world.func_72796_p(x, y = data.readInt(), z = data.readInt());
            if (te instanceof TileTrainWbench) {
                orientation = data.readByte();
                ((TileTrainWbench)te).handlePacketDataFromServer(orientation);
            }
            if (te instanceof TileCrafterTierIII) {
                orientation = data.readByte();
                ((TileCrafterTierIII)te).handlePacketDataFromServer(orientation);
            }
            if (te instanceof TileCrafterTierII) {
                orientation = data.readByte();
                ((TileCrafterTierII)te).handlePacketDataFromServer(orientation);
            }
            if (te instanceof TileCrafterTierI) {
                orientation = data.readByte();
                ((TileCrafterTierI)te).handlePacketDataFromServer(orientation);
            }
            if (te instanceof TileStopper) {
                orientation = data.readByte();
                ((TileStopper)te).handlePacketDataFromServer(orientation);
            }
            if (te instanceof TileBook) {
                orientation = data.readByte();
                ((TileBook)te).handlePacketDataFromServer(orientation);
            }
            if (te instanceof TileSignal) {
                orientation = data.readByte();
                ((TileSignal)te).handlePacketDataFromServer(orientation);
            }
            if (te instanceof TileLantern) {
                int color = data.readInt();
                ((TileLantern)te).handlePacketDataFromServer(color);
            }
            if (te instanceof TileWaterWheel) {
                orientation = data.readByte();
                ((TileWaterWheel)te).handlePacketDataFromServer(orientation);
            }
            if (te instanceof TileWindMill) {
                orientation = data.readByte();
                int wind = data.readInt();
                ((TileWindMill)te).handlePacketDataFromServer(orientation, wind);
            }
            if (te instanceof TileGeneratorDiesel) {
                orientation = data.readByte();
                ((TileGeneratorDiesel)te).handlePacketDataFromServer(orientation);
            }
        } else if (packetIndex == 1) {
            short burnTime;
            short cookTime;
            byte orientation;
            int z;
            int y;
            int x = data.readInt();
            TileEntity te = world.func_72796_p(x, y = data.readInt(), z = data.readInt());
            if (te instanceof TileEntityDistil) {
                orientation = data.readByte();
                cookTime = data.readShort();
                burnTime = data.readShort();
                short amount = data.readShort();
                short liquidID = data.readShort();
                ((TileEntityDistil)te).handlePacketDataFromServer(orientation, cookTime, burnTime, amount, liquidID);
            }
            if (te instanceof TileEntityOpenHearthFurnace) {
                orientation = data.readByte();
                cookTime = data.readShort();
                burnTime = data.readShort();
                ((TileEntityOpenHearthFurnace)te).handlePacketDataFromServer(orientation, cookTime, burnTime);
            }
        } else if (packetIndex == 2) {
            int ID = data.readInt();
            boolean brake = data.readBoolean();
            if (player != null && player instanceof EntityPlayer && ((EntityPlayer)player).field_70154_o != null && ((EntityPlayer)player).field_70154_o instanceof Locomotive) {
                Locomotive lo = (Locomotive)((EntityPlayer)player).field_70154_o;
                if (lo.field_70157_k == ID) {
                    lo.setParkingBrakeFromPacket(brake);
                }
            }
        } else if (packetIndex == 3 || packetIndex == 4) {
            int ID = data.readInt();
            int set = data.readInt();
            AxisAlignedBB box = ((EntityPlayer)player).field_70121_D.func_72314_b(5.0, 5.0, 5.0);
            List lis3 = ((EntityPlayer)player).field_70170_p.func_72839_b((Entity)player, box);
            if (lis3 != null && lis3.size() > 0) {
                for (int j1 = 0; j1 < lis3.size(); ++j1) {
                    Entity entity = (Entity)lis3.get(j1);
                    if (!(entity instanceof EntityTracksBuilder) || ((EntityTracksBuilder)entity).field_70157_k != ID) continue;
                    if (packetIndex == 3) {
                        ((EntityTracksBuilder)entity).setPlannedHeightFromPacket(set);
                    }
                    if (packetIndex != 4) continue;
                    ((EntityTracksBuilder)entity).setFollowTracksFromPacket(set);
                }
            }
        } else if (packetIndex == 5) {
            int z;
            int y;
            int x = data.readInt();
            TileEntity te = world.func_72796_p(x, y = data.readInt(), z = data.readInt());
            if (te instanceof TileEntityDistil) {
                short amount = data.readShort();
                short liquidID = data.readShort();
                ((TileEntityDistil)te).handlePacketDataFromServer(amount, liquidID);
            }
        } else if (packetIndex == 6) {
            int entityID = data.readInt();
            int page = data.readInt();
            int recipe = data.readInt();
            if (((EntityPlayer)player).field_70157_k == entityID && ((EntityPlayer)player).func_71045_bC() != null && ((EntityPlayer)player).func_71045_bC().func_77973_b() instanceof ItemRecipeBook) {
                ItemStack stack = ((EntityPlayer)player).func_71045_bC();
                NBTTagCompound var3 = stack.func_77978_p();
                if (var3 == null) {
                    var3 = new NBTTagCompound();
                    stack.func_77982_d(var3);
                }
                stack.func_77978_p().func_74768_a("currPage", page);
                stack.func_77978_p().func_74768_a("currRecipe", recipe);
            }
        } else if (packetIndex == 7) {
            int z;
            int y;
            int x = data.readInt();
            TileEntity te = world.func_72796_p(x, y = data.readInt(), z = data.readInt());
            if (te instanceof TileGeneratorDiesel) {
                boolean producing = data.readBoolean();
                short amount = data.readShort();
                short liquidID = data.readShort();
                ((TileGeneratorDiesel)te).handlePacketDataFromServer(producing, amount, liquidID);
            }
        } else if (packetIndex == 11) {
            int entityID = data.readInt();
            int rotationServer = data.readInt();
            int realRotation = data.readInt();
            int anglePitch = data.readInt();
            Entity entity = this.getEntityByID(entityID, player);
            if (entity instanceof EntityRollingStock) {
                ((EntityRollingStock)entity).rotationYawClient = rotationServer;
                ((EntityRollingStock)entity).rotationYawClientReal = realRotation;
                ((EntityRollingStock)entity).anglePitchClient = anglePitch;
            }
        } else if (packetIndex == 12) {
            int ID = data.readInt();
            boolean locked = data.readBoolean();
            AxisAlignedBB box = ((EntityPlayer)player).field_70121_D.func_72314_b(5.0, 5.0, 5.0);
            List lis3 = ((EntityPlayer)player).field_70170_p.func_72839_b((Entity)player, box);
            if (lis3 != null && lis3.size() > 0) {
                for (int j1 = 0; j1 < lis3.size(); ++j1) {
                    Entity entity = (Entity)lis3.get(j1);
                    if (!(entity instanceof AbstractTrains) || ((AbstractTrains)entity).field_70157_k != ID) continue;
                    ((AbstractTrains)entity).setTrainLockedFromPacket(locked);
                }
            }
        } else if (packetIndex == 13) {
            int ID = data.readInt();
            boolean locked = data.readBoolean();
            String theOwner = data.readLine();
            AxisAlignedBB box = ((EntityPlayer)player).field_70121_D.func_72314_b(5.0, 5.0, 5.0);
            List lis3 = ((EntityPlayer)player).field_70170_p.func_72839_b((Entity)player, box);
            if (lis3 != null && lis3.size() > 0) {
                for (int j1 = 0; j1 < lis3.size(); ++j1) {
                    Entity entity = (Entity)lis3.get(j1);
                    if (!(entity instanceof AbstractTrains) || ((AbstractTrains)entity).field_70157_k != ID) continue;
                    ((AbstractTrains)entity).setTrainLockedFromPacket(locked, theOwner);
                }
            }
        } else if (packetIndex == 14) {
            int entityID = data.readInt();
            int rotationServer = data.readInt();
            int roll = data.readInt();
            Entity entity = this.getEntityByID(entityID, player);
            if (entity instanceof AbstractZeppelin) {
                ((AbstractZeppelin)entity).rotationYawClient = rotationServer;
                ((AbstractZeppelin)entity).roll = roll;
            }
        } else if (packetIndex == 15) {
            int entityID = data.readInt();
            String url = data.readUTF();
            boolean playing = data.readBoolean();
            Entity entity = this.getEntityByID(entityID, player);
            if (entity instanceof EntityJukeBoxCart) {
                ((EntityJukeBoxCart)entity).recievePacket(url, playing);
            }
        } else if (packetIndex == 16) {
            int entityID = data.readInt();
            int slotsFilled = data.readInt();
            Entity entity = this.getEntityByID(entityID, player);
            if (entity instanceof Locomotive) {
                ((Locomotive)entity).recieveSlotsFilled(slotsFilled);
            }
        }
    }

    private Entity getEntityByID(int par1, Player player) {
        return (Entity)(par1 == ((EntityPlayer)player).field_70157_k ? player : ((EntityPlayer)player).field_70170_p.func_73045_a(par1));
    }

    public static Packet getTEPClient(TileEntity te) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            TileEntity tem;
            if (te != null && te instanceof TileTrainWbench) {
                tem = (TileTrainWbench)te;
                dos.writeInt(0);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(tem.getFacing().ordinal());
            }
            if (te != null && te instanceof TileCrafterTierIII) {
                tem = (TileCrafterTierIII)te;
                dos.writeInt(0);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(tem.getFacing().ordinal());
            }
            if (te != null && te instanceof TileCrafterTierII) {
                tem = (TileCrafterTierII)te;
                dos.writeInt(0);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(tem.getFacing().ordinal());
            }
            if (te != null && te instanceof TileCrafterTierI) {
                tem = (TileCrafterTierI)te;
                dos.writeInt(0);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(tem.getFacing().ordinal());
            }
            if (te != null && te instanceof TileEntityDistil) {
                tem = (TileEntityDistil)te;
                dos.writeInt(1);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(tem.getFacing().ordinal());
                dos.writeShort(tem.distilCookTime);
                dos.writeShort(tem.distilBurnTime);
                dos.writeShort(tem.amount);
                dos.writeShort(tem.liquidItemID);
            }
            if (te != null && te instanceof TileEntityOpenHearthFurnace) {
                tem = (TileEntityOpenHearthFurnace)te;
                dos.writeInt(1);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(tem.getFacing().ordinal());
                dos.writeShort(tem.furnaceCookTime);
                dos.writeShort(tem.furnaceBurnTime);
            }
            if (te != null && te instanceof TileStopper) {
                tem = (TileStopper)te;
                dos.writeInt(0);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(tem.getFacing());
            }
            if (te != null && te instanceof TileBook) {
                tem = (TileBook)te;
                dos.writeInt(0);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(tem.getFacing());
            }
            if (te != null && te instanceof TileSignal) {
                tem = (TileSignal)te;
                dos.writeInt(0);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(tem.getFacing());
            }
            if (te != null && te instanceof TileLantern) {
                tem = (TileLantern)te;
                dos.writeInt(0);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeInt(tem.randomColor);
            }
            if (te != null && te instanceof TileWaterWheel) {
                tem = (TileWaterWheel)te;
                dos.writeInt(0);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(tem.getFacing());
            }
            if (te != null && te instanceof TileWindMill) {
                tem = (TileWindMill)te;
                dos.writeInt(0);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(tem.getFacing());
                dos.writeInt(ServerTickHandler.windStrength);
            }
            if (te != null && te instanceof TileGeneratorDiesel) {
                tem = (TileGeneratorDiesel)te;
                dos.writeInt(0);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(tem.getFacing());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        return packet;
    }

    public static Packet setDistilLiquid(TileEntity te) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (te != null && te instanceof TileEntityDistil) {
                TileEntityDistil tem = (TileEntityDistil)te;
                dos.writeInt(5);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeShort(tem.amount);
                dos.writeShort(tem.liquidItemID);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        return packet;
    }

    public static Packet setRotationPacket(Entity entity, float rotationYawServer, float realRotation, float anglePitch) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (entity != null && entity instanceof EntityRollingStock) {
                dos.writeInt(11);
                dos.writeInt(entity.field_70157_k);
                dos.writeInt((int)rotationYawServer);
                dos.writeInt((int)realRotation);
                dos.writeInt((int)anglePitch);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        return packet;
    }

    public static Packet setRotationPacketZeppelin(Entity entity, float rotationYawServer, float roll) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (entity != null && entity instanceof AbstractZeppelin) {
                dos.writeInt(14);
                dos.writeInt(entity.field_70157_k);
                dos.writeInt((int)rotationYawServer);
                dos.writeInt((int)roll);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        return packet;
    }

    public static void sendPacketToClients(Packet packet, World worldObj, int x, int y, int z, double range) {
        try {
            PacketDispatcher.sendPacketToAllAround((double)x, (double)y, (double)z, (double)range, (int)worldObj.field_73011_w.field_76574_g, (Packet)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static Packet setParkingBrake(Entity player, Entity entity, boolean set) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (entity instanceof Locomotive) {
                Locomotive lo = (Locomotive)entity;
                dos.writeInt(2);
                dos.writeInt(lo.field_70157_k);
                dos.writeBoolean(set);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        if (player instanceof EntityClientPlayerMP) {
            EntityClientPlayerMP playerMP = (EntityClientPlayerMP)player;
            playerMP.field_71174_a.func_72552_c((Packet)packet);
        }
        return packet;
    }

    public static Packet setTrainLocked(Entity player, Entity entity, boolean set) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (entity instanceof AbstractTrains) {
                AbstractTrains lo = (AbstractTrains)entity;
                dos.writeInt(12);
                dos.writeInt(lo.field_70157_k);
                dos.writeBoolean(set);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        if (player instanceof EntityClientPlayerMP) {
            EntityClientPlayerMP playerMP = (EntityClientPlayerMP)player;
            playerMP.field_71174_a.func_72552_c((Packet)packet);
        }
        return packet;
    }

    public static Packet setTrainLockedToClient(Entity player, Entity entity, boolean set) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (entity instanceof AbstractTrains) {
                AbstractTrains lo = (AbstractTrains)entity;
                dos.writeInt(13);
                dos.writeInt(lo.field_70157_k);
                dos.writeBoolean(set);
                dos.writeBytes(lo.trainOwner);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        return packet;
    }

    public static Packet setBuilderPlannedHeight(Entity player, Entity entity, int set, int packetID) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (entity instanceof EntityTracksBuilder) {
                EntityTracksBuilder lo = (EntityTracksBuilder)entity;
                dos.writeInt(packetID);
                dos.writeInt(lo.field_70157_k);
                dos.writeInt(set);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        if (player instanceof EntityClientPlayerMP) {
            EntityClientPlayerMP playerMP = (EntityClientPlayerMP)player;
            playerMP.field_71174_a.func_72552_c((Packet)packet);
        }
        return packet;
    }

    public static Packet setBookPage(Entity player, int page, int recipe) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(6);
            dos.writeInt(player.field_70157_k);
            dos.writeInt(page);
            dos.writeInt(recipe);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        if (player instanceof EntityClientPlayerMP) {
            EntityClientPlayerMP playerMP = (EntityClientPlayerMP)player;
            playerMP.field_71174_a.func_72552_c((Packet)packet);
        }
        return packet;
    }

    public static Packet setJukeBoxStreamingUrl(EntityPlayer player, Entity entity, String url, boolean isPlaying) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (entity != null && entity instanceof EntityJukeBoxCart) {
                dos.writeInt(15);
                dos.writeInt(entity.field_70157_k);
                dos.writeUTF(url);
                dos.writeBoolean(isPlaying);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        if (player instanceof EntityClientPlayerMP) {
            EntityClientPlayerMP playerMP = (EntityClientPlayerMP)player;
            playerMP.field_71174_a.func_72552_c((Packet)packet);
        }
        return packet;
    }

    public static Packet setSlotsFilledPacket(Entity entity, int slotsFilled) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (entity instanceof AbstractTrains) {
                AbstractTrains lo = (AbstractTrains)entity;
                dos.writeInt(16);
                dos.writeInt(lo.field_70157_k);
                dos.writeInt(slotsFilled);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        return packet;
    }
}

