/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.core.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import src.train.common.Traincraft;
import src.train.common.api.AbstractTrains;
import src.train.common.core.handlers.ConfigHandler;
import src.train.common.mysql.mysqlLogger;

public class RollingStockStatsEventHandler {
    private ArrayList<playerDistance> plDist = new ArrayList();
    private AbstractTrains train;
    private mysqlLogger logger;

    public RollingStockStatsEventHandler(AbstractTrains train) {
        this.train = train;
        this.logger = new mysqlLogger();
    }

    public RollingStockStatsEventHandler() {
        this.logger = new mysqlLogger();
    }

    public void trainDistance() {
        double xDist = this.train.field_70169_q - this.train.field_70165_t;
        double yDist = this.train.field_70167_r - this.train.field_70163_u;
        double zDist = this.train.field_70166_s - this.train.field_70161_v;
        int var7 = Math.round(MathHelper.func_76133_a((double)(xDist * xDist + yDist * yDist + zDist * zDist)) * 100.0f);
        this.train.trainDistanceTraveled += (double)var7;
        if (this.train.field_70153_n != null && this.train.field_70153_n instanceof EntityPlayer) {
            for (playerDistance d : this.plDist) {
                if (!((EntityPlayer)this.train.field_70153_n).field_71092_bJ.equals(d.getUsername())) continue;
                d.setDistance(d.getDistance() + (double)var7);
                return;
            }
            this.plDist.add(new playerDistance(((EntityPlayer)this.train.field_70153_n).field_71092_bJ, var7));
        }
    }

    private String castToString(double str) {
        return "" + str;
    }

    public void trainDestroy(int trainID, String trainName, String trainType, String trainCreator, String trainDestroyer, String pos) {
        HashMap<String, String> destroy = new HashMap<String, String>();
        if (trainID < 1) {
            return;
        }
        destroy.put("uID", new String(this.castToString(trainID)));
        destroy.put("itemID", trainName);
        destroy.put("trainType", trainType);
        destroy.put("trainCreator", trainCreator);
        destroy.put("trainDestroyer", trainDestroyer);
        destroy.put("location", pos);
        if (Traincraft.mysqlLoggerEnabled && ConfigHandler.MYSQL_ENABLE) {
            this.logger.logEvent("trainDestroy", destroy);
        }
    }

    public void trainExplode(int trainID, String trainName, String trainType, String trainCreator, String pos) {
        HashMap<String, String> explode = new HashMap<String, String>();
        if (trainID < 1) {
            return;
        }
        explode.put("uID", new String(this.castToString(trainID)));
        explode.put("itemID", trainName);
        explode.put("trainType", trainType);
        explode.put("trainCreator", trainCreator);
        explode.put("location", pos);
        if (Traincraft.mysqlLoggerEnabled && ConfigHandler.MYSQL_ENABLE) {
            this.logger.logEvent("trainExplode", explode);
        }
    }

    public void trainCreate(int trainID, String trainName, String trainType, String trainCreator, String pos) {
        HashMap<String, String> create = new HashMap<String, String>();
        if (trainID < 1) {
            return;
        }
        create.put("uID", new String(this.castToString(trainID)));
        create.put("itemID", trainName);
        create.put("trainType", trainType);
        create.put("trainCreator", trainCreator);
        create.put("location", pos);
        if (Traincraft.mysqlLoggerEnabled && ConfigHandler.MYSQL_ENABLE) {
            this.logger.logEvent("trainCreate", create);
        }
    }

    public void trainPlace(int trainID, String trainName, String trainType, String trainCreator, String trainPlacer, String pos) {
        HashMap<String, String> place = new HashMap<String, String>();
        if (trainID < 1) {
            return;
        }
        place.put("uID", new String(this.castToString(trainID)));
        place.put("itemID", trainName);
        place.put("trainType", trainType);
        place.put("trainCreator", trainCreator);
        place.put("trainPlacer", trainPlacer);
        place.put("location", pos);
        if (Traincraft.mysqlLoggerEnabled && ConfigHandler.MYSQL_ENABLE) {
            this.logger.logEvent("trainPlace", place);
        }
    }

    public void trainPaint(int trainID, String trainName, String trainType, String trainCreator, String trainInteracter, String color, String pos) {
        HashMap<String, String> paint = new HashMap<String, String>();
        if (trainID < 1) {
            return;
        }
        paint.put("uID", new String(this.castToString(trainID)));
        paint.put("itemID", trainName);
        paint.put("trainType", trainType);
        paint.put("trainCreator", trainCreator);
        paint.put("color", color);
        paint.put("location", pos);
        paint.put("trainInteracter", trainInteracter);
        if (Traincraft.mysqlLoggerEnabled && ConfigHandler.MYSQL_ENABLE) {
            this.logger.logEvent("trainColor", paint);
        }
    }

    private class playerDistance {
        private String username;
        private double distance;

        private playerDistance(String username, double distance) {
            this.username = username;
            this.distance = distance;
        }

        protected double getDistance() {
            return this.distance;
        }

        protected String getUsername() {
            return this.username;
        }

        protected void setDistance(double distance) {
            this.distance = distance;
        }
    }
}

