/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.core.managers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import src.train.common.api.crafting.ITierRecipe;

public class TierRecipe
implements ITierRecipe {
    private final int tier;
    private final ItemStack planks;
    private final ItemStack wheels;
    private final ItemStack frame;
    private final ItemStack coupler;
    private final ItemStack chimney;
    private final ItemStack cab;
    private final ItemStack boiler;
    private final ItemStack firebox;
    private final ItemStack additional;
    private final ItemStack dye;
    private final ItemStack output;
    private final int outputSize;
    private final List<ItemStack> stacks;

    public TierRecipe(int tier, ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye, ItemStack output, int outputSize) {
        this.tier = tier;
        this.planks = planks;
        this.wheels = wheels;
        this.frame = frame;
        this.coupler = coupler;
        this.chimney = chimney;
        this.cab = cab;
        this.boiler = boiler;
        this.firebox = firebox;
        this.additional = additional;
        this.dye = dye;
        this.output = output;
        this.outputSize = outputSize;
        this.stacks = new ArrayList<ItemStack>();
        this.stacks.add(0, planks);
        this.stacks.add(1, wheels);
        this.stacks.add(2, frame);
        this.stacks.add(3, coupler);
        this.stacks.add(4, chimney);
        this.stacks.add(5, cab);
        this.stacks.add(6, boiler);
        this.stacks.add(7, firebox);
        this.stacks.add(8, additional);
        this.stacks.add(9, dye);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public int getOutputSize() {
        return this.outputSize;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public String getRecipeName() {
        return this.output.func_82833_r();
    }

    @Override
    public ItemStack getRecipeIn(int slot) {
        ItemStack stack;
        switch (slot) {
            case 0: {
                stack = this.planks;
            }
            case 1: {
                stack = this.wheels;
            }
            case 2: {
                stack = this.frame;
            }
            case 3: {
                stack = this.coupler;
            }
            case 4: {
                stack = this.chimney;
            }
            case 5: {
                stack = this.cab;
            }
            case 6: {
                stack = this.boiler;
            }
            case 7: {
                stack = this.firebox;
            }
            case 8: {
                stack = this.additional;
            }
            case 9: {
                stack = this.dye;
            }
        }
        stack = null;
        return stack;
    }

    @Override
    public List<ItemStack> getInput() {
        List list = TierRecipe.getList(this.planks, this.wheels, this.frame, this.coupler, this.chimney, this.cab, this.boiler, this.firebox, this.additional, this.dye);
        return list;
    }

    public static List getList(ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(0, planks);
        list.add(1, wheels);
        list.add(2, frame);
        list.add(3, coupler);
        list.add(4, chimney);
        list.add(5, cab);
        list.add(6, boiler);
        list.add(7, firebox);
        list.add(8, additional);
        list.add(9, dye);
        return list;
    }

    public ItemStack hasComponents(ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye) {
        List list = TierRecipe.getList(planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye);
        int x = 0;
        for (int i = 0; i < 10; ++i) {
            if (!TierRecipe.areItemsIdentical((ItemStack)list.get(i), this.stacks.get(i)) || !TierRecipe.areSizesIdentical((ItemStack)list.get(i), this.stacks.get(i))) continue;
            ++x;
        }
        if (x == 10) {
            return this.output;
        }
        return null;
    }

    public static boolean areItemsIdentical(ItemStack inSlot, ItemStack inRecipe) {
        if (inRecipe == null) {
            return true;
        }
        if (inRecipe.func_77960_j() == Short.MAX_VALUE) {
            if (inSlot == null && inRecipe != null) {
                return false;
            }
            if (inSlot.field_77993_c == inRecipe.field_77993_c) {
                return true;
            }
        } else {
            if (inSlot == null && inRecipe != null) {
                return false;
            }
            if (inSlot.field_77993_c == inRecipe.field_77993_c && inSlot.func_77960_j() == inRecipe.func_77960_j()) {
                return true;
            }
        }
        return false;
    }

    public static boolean areSizesIdentical(ItemStack inSlot, ItemStack inRecipe) {
        if (inRecipe == null) {
            return true;
        }
        if (inSlot == null && inRecipe != null) {
            return false;
        }
        return inSlot.field_77994_a >= inRecipe.field_77994_a;
    }

    @Override
    public int toDecrease(int slot) {
        if (this.stacks.get(slot) != null) {
            return this.stacks.get((int)slot).field_77994_a;
        }
        return 0;
    }
}

