/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.api.core.items.IMinecartItem;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import src.train.common.Traincraft;
import src.train.common.api.AbstractTrains;
import src.train.common.api.DieselTrain;
import src.train.common.api.ElectricTrain;
import src.train.common.api.EntityRollingStock;
import src.train.common.api.SteamTrain;
import src.train.common.api.Tender;
import src.train.common.core.handlers.ConfigHandler;
import src.train.common.core.handlers.RollingStockStatsEventHandler;
import src.train.common.entity.rollingStock.EntityTracksBuilder;
import src.train.common.library.EnumTrains;
import src.train.common.library.ItemIDs;

public class ItemRollingStock
extends ItemMinecart
implements IMinecart,
IMinecartItem {
    private String trainName;
    private String trainCreator;
    private int trainColor = -1;
    private RollingStockStatsEventHandler statsEvent = new RollingStockStatsEventHandler();

    public ItemRollingStock(int i) {
        super(i, 1);
        this.field_77777_bU = 1;
        this.trainName = this.func_77658_a();
        this.func_77637_a(Traincraft.tcTab);
    }

    public int setNewUniqueID(ItemStack stack, EntityPlayer player, int numberOfTrains) {
        NBTTagCompound var3 = stack.func_77978_p();
        if (numberOfTrains <= 0) {
            numberOfTrains = AbstractTrains.uniqueIDs++;
        } else {
            AbstractTrains.uniqueIDs = numberOfTrains++;
        }
        if (var3 == null) {
            var3 = new NBTTagCompound();
            stack.func_77982_d(var3);
        }
        stack.func_77978_p().func_74768_a("uniqueID", numberOfTrains);
        stack.func_77978_p().func_74778_a("trainCreator", player.field_71092_bJ);
        return numberOfTrains;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack.func_77942_o()) {
            NBTTagCompound var5 = par1ItemStack.func_77978_p();
            int id = var5.func_74762_e("uniqueID");
            this.trainCreator = var5.func_74779_i("trainCreator");
            if (this.trainCreator.length() > 0) {
                par3List.add("\u00a77Creator: " + this.trainCreator);
            }
            int color = var5.func_74762_e("trainColor");
            if (var5.func_74764_b("trainColor") && color <= 16) {
                par3List.add("\u00a77Color: " + AbstractTrains.getColorAsString(color));
            }
        }
        double mass = this.getMass();
        int power = this.getMHP();
        int maxSpeed = this.getMaxSpeed();
        String[] additionnalInfo = this.getAdditionnalInfo();
        if (this.getTrainType().length() > 0) {
            par3List.add("\u00a77Type: " + this.getTrainType());
        }
        if (power > 0) {
            par3List.add("\u00a77Power: " + power + " Mhp");
        }
        if (mass > 0.0) {
            par3List.add("\u00a77Mass: " + mass * 10.0);
        }
        if (maxSpeed > 0) {
            par3List.add("\u00a77Max Speed: " + maxSpeed);
        }
        if (this.getCargoCapacity() > 0) {
            par3List.add("\u00a77Slots: " + this.getCargoCapacity());
        }
        if (additionnalInfo != null && additionnalInfo.length > 0 && additionnalInfo[0].length() > 0) {
            for (int i = 0; i < additionnalInfo.length; ++i) {
                if (additionnalInfo[i].length() <= 0) continue;
                par3List.add("\u00a77" + additionnalInfo[i]);
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    public String getTrainType() {
        for (EnumTrains trains : EnumTrains.values()) {
            if (trains.getItem().field_77779_bT != this.field_77779_bT) continue;
            return trains.getTrainType();
        }
        return "";
    }

    public double getMass() {
        for (EnumTrains trains : EnumTrains.values()) {
            if (trains.getItem().field_77779_bT != this.field_77779_bT) continue;
            return trains.getMass();
        }
        return 0.0;
    }

    public int getMaxSpeed() {
        for (EnumTrains trains : EnumTrains.values()) {
            if (trains.getItem().field_77779_bT != this.field_77779_bT) continue;
            return trains.getMaxSpeed();
        }
        return 0;
    }

    public int getMHP() {
        for (EnumTrains trains : EnumTrains.values()) {
            if (trains.getItem().field_77779_bT != this.field_77779_bT) continue;
            return trains.getMHP();
        }
        return 0;
    }

    public String[] getAdditionnalInfo() {
        for (EnumTrains trains : EnumTrains.values()) {
            if (trains.getItem().field_77779_bT != this.field_77779_bT) continue;
            return trains.getAdditionnalTooltip();
        }
        return null;
    }

    public int getCargoCapacity() {
        for (EnumTrains trains : EnumTrains.values()) {
            if (trains.getItem().field_77779_bT != this.field_77779_bT) continue;
            return trains.getCargoCapacity();
        }
        return 0;
    }

    public String getTrainName() {
        return this.trainName;
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        int var11 = par3World.func_72798_a(par4, par5, par6);
        int meta = par3World.func_72805_g(par4, par5, par6);
        if (BlockRailBase.func_72184_d((int)var11) && (meta < 2 || meta > 5)) {
            this.placeCart(par2EntityPlayer, par1ItemStack, par3World, par4, par5, par6);
            return true;
        }
        return false;
    }

    public EntityMinecart placeCart(EntityPlayer player, ItemStack itemstack, World world, int i, int j, int k) {
        EntityRollingStock rollingStock = null;
        for (EnumTrains train : EnumTrains.values()) {
            if (train.getItem().field_77779_bT != itemstack.field_77993_c) continue;
            rollingStock = (EntityRollingStock)train.getEntity(world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f);
            if (train.getColors() == null) continue;
            rollingStock.setColor(EntityRollingStock.getColorFromString(train.getColors()[0]));
        }
        if (rollingStock != null && rollingStock instanceof EntityRollingStock) {
            if (!world.field_72995_K) {
                if (rollingStock instanceof SteamTrain && !ConfigHandler.ENABLE_STEAM || rollingStock instanceof ElectricTrain && !ConfigHandler.ENABLE_ELECTRIC || rollingStock instanceof DieselTrain && !ConfigHandler.ENABLE_DIESEL || rollingStock instanceof EntityTracksBuilder && !ConfigHandler.ENABLE_BUILDER || rollingStock instanceof Tender && !ConfigHandler.ENABLE_TENDER) {
                    if (player != null) {
                        player.func_71035_c("This type of train has been deactivated by the OP");
                    }
                    rollingStock.func_70106_y();
                    return rollingStock;
                }
                int dir = 0;
                int meta = world.func_72805_g(i, j, k);
                if (player != null) {
                    dir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                }
                if (dir == 2) {
                    rollingStock.field_70177_z = 0.0f;
                    rollingStock.serverRealRotation = meta == 0 ? -90.0f : 180.0f;
                }
                if (dir == 1) {
                    rollingStock.field_70177_z = 90.0f;
                    rollingStock.serverRealRotation = meta == 1 ? 180.0f : 90.0f;
                }
                if (dir == 0) {
                    rollingStock.field_70177_z = -180.0f;
                    rollingStock.serverRealRotation = meta == 0 ? 90.0f : 180.0f;
                }
                if (dir == 3) {
                    rollingStock.field_70177_z = 180.0f;
                    rollingStock.serverRealRotation = meta == 1 ? 0.0f : 90.0f;
                }
                rollingStock.trainType = ((ItemRollingStock)itemstack.func_77973_b()).getTrainType();
                rollingStock.trainName = ((ItemRollingStock)itemstack.func_77973_b()).func_77628_j(itemstack);
                if (player != null) {
                    rollingStock.trainOwner = player.field_71092_bJ;
                    CartTools.setCartOwner((EntityMinecart)rollingStock, player);
                }
                rollingStock.mass = this.getMass();
                int uniID = -1;
                if (itemstack.func_77942_o()) {
                    NBTTagCompound var5 = itemstack.func_77978_p();
                    uniID = var5.func_74762_e("uniqueID");
                    if (uniID != -1) {
                        rollingStock.uniqueID = uniID;
                    }
                    if (uniID != -1) {
                        rollingStock.getEntityData().func_74768_a("uniqueID", uniID);
                    }
                    this.trainCreator = var5.func_74779_i("trainCreator");
                    this.trainColor = var5.func_74762_e("trainColor");
                    if (var5.func_74764_b("trainColor")) {
                        rollingStock.setColor(this.trainColor);
                    }
                    rollingStock.trainCreator = this.trainCreator;
                }
                if (player != null) {
                    rollingStock.setInformation(((ItemRollingStock)itemstack.func_77973_b()).getTrainType(), player.field_71092_bJ, this.trainCreator, ((ItemRollingStock)itemstack.func_77973_b()).func_77628_j(itemstack), uniID);
                }
                if (player == null) {
                    rollingStock.setInformation(((ItemRollingStock)itemstack.func_77973_b()).getTrainType(), "", this.trainCreator, ((ItemRollingStock)itemstack.func_77973_b()).func_77628_j(itemstack), uniID);
                }
                if (ConfigHandler.SHOW_POSSIBLE_COLORS && rollingStock.acceptedColors != null && rollingStock.acceptedColors.size() > 0) {
                    String concatColors = ": ";
                    for (int t = 0; t < rollingStock.acceptedColors.size(); ++t) {
                        if (EntityRollingStock.getColorAsString((Integer)rollingStock.acceptedColors.get(t)).equals("Empty")) continue;
                        if (EntityRollingStock.getColorAsString((Integer)rollingStock.acceptedColors.get(t)).equals("Full")) continue;
                        concatColors = concatColors.concat(EntityRollingStock.getColorAsString((Integer)rollingStock.acceptedColors.get(t)) + ", ");
                    }
                    if (concatColors.length() > 4 && player != null) {
                        player.func_71035_c("Possible colors" + concatColors);
                        player.func_71035_c("To paint, click me with the right (vanilla) dye");
                    }
                }
                world.func_72838_d((Entity)rollingStock);
                if (player != null) {
                    this.statsEvent.trainPlace(rollingStock.getUniqueTrainID(), ((ItemRollingStock)itemstack.func_77973_b()).func_77628_j(itemstack), ((ItemRollingStock)itemstack.func_77973_b()).getTrainType(), this.trainCreator, player.field_71092_bJ, new String(i + ";" + j + ";" + k));
                }
            }
            --itemstack.field_77994_a;
        }
        return rollingStock;
    }

    @Override
    public boolean canBePlacedByNonPlayer(ItemStack cart) {
        return true;
    }

    @Override
    public EntityMinecart placeCart(String owner, ItemStack cart, World world, int i, int j, int k) {
        return this.placeCart((EntityPlayer)null, cart, world, i, j, k);
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("TC".toLowerCase() + ":trains/" + ItemIDs.getIcon(this.field_77779_bT));
    }
}

