/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.recipes;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import src.train.common.core.handlers.ConfigHandler;
import src.train.common.library.BlockIDs;
import src.train.common.library.ItemIDs;

public class DistilRecipes {
    private static final DistilRecipes smeltingBase = new DistilRecipes();
    private Map smeltingList;
    private Map experienceList = new HashMap();
    private Map plasticChanceList = new HashMap();
    private Map plasticList = new HashMap();

    public static final DistilRecipes smelting() {
        return smeltingBase;
    }

    private DistilRecipes() {
        this.smeltingList = new HashMap();
        if (ConfigHandler.ORE_GEN) {
            this.addSmelting(BlockIDs.oreTC.blockID, new ItemStack(ItemIDs.diesel.item, 2), 0.5f, 1, new ItemStack(ItemIDs.rawPlastic.item, 1));
        }
        this.addSmelting(Item.field_77758_aJ.field_77779_bT, new ItemStack(ItemIDs.diesel.item), 0.2f, 4, new ItemStack(ItemIDs.rawPlastic.item, 1));
        this.addSmelting(Block.field_71952_K.field_71990_ca, new ItemStack(ItemIDs.diesel.item), 0.2f, 6, new ItemStack(ItemIDs.rawPlastic.item, 2));
        this.addSmelting(ItemIDs.diesel.item.field_77779_bT, new ItemStack(ItemIDs.refinedFuel.item), 1.0f, 2, new ItemStack(ItemIDs.rawPlastic.item, 1));
        this.addSmelting(Item.field_77685_T.field_77779_bT, new ItemStack(ItemIDs.diesel.item), 0.2f, 4, new ItemStack(ItemIDs.rawPlastic.item, 1));
    }

    public void addSmelting(int i, ItemStack itemstack, float exp, int plasticChance, ItemStack plasticStack) {
        this.smeltingList.put(i, itemstack);
        this.plasticList.put(i, plasticStack);
        this.experienceList.put(plasticStack.func_77973_b().field_77779_bT, Float.valueOf(exp));
        this.plasticChanceList.put(i, Float.valueOf(plasticChance));
    }

    public float getExperience(int i) {
        return this.experienceList.containsKey(i) ? ((Float)this.experienceList.get(i)).floatValue() : 0.0f;
    }

    public int getPlasticChance(int i) {
        if (this.plasticChanceList.containsKey(i)) {
            return (int)((Float)this.plasticChanceList.get(i)).floatValue();
        }
        return 0;
    }

    public ItemStack getSmeltingResult(int i) {
        return (ItemStack)this.smeltingList.get(i);
    }

    public ItemStack getPlasticResult(int i) {
        return (ItemStack)this.plasticList.get(i);
    }

    public Map getSmeltingList() {
        return this.smeltingList;
    }
}

