/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import src.train.common.blocks.tracks.BlockEnergyTrack;
import src.train.common.core.handlers.OverheadLinesEnergyNetHandler;

public class TileEntityOverheadLines
extends TileEntity
implements IEnergySink {
    public double energy = 0.0;
    public int maxEnergy = 1024;
    public int tier = 1;
    public int output;
    private int facing = 0;
    public static OverheadLinesEnergyNetHandler network = new OverheadLinesEnergyNetHandler();
    private int updateTicks = 0;
    public boolean isProvider = false;
    public boolean Up = false;
    public boolean Down = false;
    public boolean Left = false;
    public boolean Right = false;
    public boolean Back = false;
    public boolean Front = false;
    public boolean addedToEnergyNet = false;

    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    public int getFacing() {
        return this.facing;
    }

    public void setFacing(int facing) {
        this.facing = facing;
    }

    public void func_70316_g() {
        double output;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        ++this.updateTicks;
        if (!this.addedToEnergyNet) {
            network.addToNetwork(this);
            this.addedToEnergyNet = true;
            if (!this.isSimulating() || !this.addedToEnergyNet) {
                // empty if block
            }
        }
        if (this.updateTicks % 200 == 0) {
            network.cleanNetwork();
        }
        if (this.updateTicks % 5 == 0 && network != null && network.getNetwork() != null && network.getNetwork().size() > 0 && this.energy >= this.getMaxEnergy() - 1.0 && (output = Math.min((double)this.output, this.energy)) > 0.0) {
            this.energy = (short)(this.energy - (double)this.sendEnergy(output));
        }
    }

    public double getDistanceSq(double par1, double par3, double par5) {
        double var7 = (double)this.field_70329_l - par1;
        double var9 = (double)this.field_70330_m - par3;
        if (Math.abs(var9) == 1.0) {
            var9 = 0.0;
        }
        double var11 = (double)this.field_70327_n - par5;
        return Math.sqrt(var7 * var7 + var11 * var11);
    }

    public int sendEnergy(double send) {
        for (int i = 0; i < network.getNetwork().size(); ++i) {
            if (network.getNetwork().get(i) == null || network.getNetwork().get(i).equals(this)) continue;
            int x2 = ((BlockEnergyTrack)network.getNetwork().get(i)).getX();
            int y2 = ((BlockEnergyTrack)network.getNetwork().get(i)).getY();
            int z2 = ((BlockEnergyTrack)network.getNetwork().get(i)).getZ();
            if (((BlockEnergyTrack)TileEntityOverheadLines.network.getNetwork().get((int)i)).isProvider || !this.isProvider || !(((TileEntityOverheadLines)network.getNetwork().get(i)).getEnergy() < ((TileEntityOverheadLines)network.getNetwork().get(i)).getMaxEnergy()) || !(this.getDistanceSq(x2, y2, z2) <= 50.0)) continue;
            double transfered = ((TileEntityOverheadLines)network.getNetwork().get(i)).getMaxEnergy() - ((TileEntityOverheadLines)network.getNetwork().get(i)).getEnergy();
            transfered = Math.min((double)this.output, transfered);
            ((TileEntityOverheadLines)network.getNetwork().get(i)).setEnergy(transfered + ((TileEntityOverheadLines)network.getNetwork().get(i)).getEnergy());
            if (!(transfered > 0.0)) continue;
            return (int)transfered;
        }
        return 0;
    }

    public boolean isSimulating() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void onChunkUnload() {
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74780_a("energy", this.energy);
        par1NBTTagCompound.func_74768_a("facing", this.facing);
        par1NBTTagCompound.func_74757_a("Up", this.Up);
        par1NBTTagCompound.func_74757_a("Down", this.Down);
        par1NBTTagCompound.func_74757_a("Left", this.Left);
        par1NBTTagCompound.func_74757_a("Right", this.Right);
        par1NBTTagCompound.func_74757_a("Back", this.Back);
        par1NBTTagCompound.func_74757_a("Front", this.Front);
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        this.energy = par1NBTTagCompound.func_74769_h("energy");
        this.facing = par1NBTTagCompound.func_74762_e("facing");
        this.Up = par1NBTTagCompound.func_74767_n("Up");
        this.Down = par1NBTTagCompound.func_74767_n("Down");
        this.Left = par1NBTTagCompound.func_74767_n("Left");
        this.Right = par1NBTTagCompound.func_74767_n("Right");
        this.Back = par1NBTTagCompound.func_74767_n("Back");
        this.Front = par1NBTTagCompound.func_74767_n("Front");
    }

    @Override
    public double demandedEnergyUnits() {
        return this.getMaxEnergy() - this.getEnergy();
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        this.energy += amount;
        this.isProvider = true;
        if (this.energy > this.getMaxEnergy()) {
            double reject = this.energy - this.getMaxEnergy();
            this.energy = this.getMaxEnergy();
            return reject;
        }
        return 0.0;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double energy) {
        this.energy = energy;
    }

    public double getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public int getMaxSafeInput() {
        return 1024;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public boolean facingMatchesDirection(Direction direction) {
        return direction.toSideValue() == this.getFacing();
    }
}

