/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.network;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.driveables.DriveablePart;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.driveables.EnumDriveablePart;
import co.uk.flansmods.common.network.FlanPacketCommon;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class PacketDriveableDamage
extends FlanPacketCommon {
    public static final byte packetID = 11;

    public static Packet buildUpdatePacket(EntityDriveable driveable) {
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = channelFlan;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(11);
            data.writeInt(driveable.field_70157_k);
            for (EnumDriveablePart ep : EnumDriveablePart.values()) {
                DriveablePart part = driveable.getDriveableData().parts.get((Object)ep);
                data.writeShort((short)part.health);
                data.writeBoolean(part.onFire);
            }
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            data.close();
            bytes.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packet;
    }

    @Override
    public void interpret(DataInputStream stream, Object[] extradata, Side side) {
        try {
            EntityPlayer player = (EntityPlayer)extradata[0];
            int entityId = stream.readInt();
            EntityDriveable driveable = null;
            for (Object obj : player.field_70170_p.field_72996_f) {
                if (!(obj instanceof EntityDriveable) || ((Entity)obj).field_70157_k != entityId) continue;
                driveable = (EntityDriveable)obj;
                break;
            }
            if (driveable != null) {
                for (EnumDriveablePart ep : EnumDriveablePart.values()) {
                    DriveablePart part = driveable.getDriveableData().parts.get((Object)ep);
                    part.health = stream.readShort();
                    part.onFire = stream.readBoolean();
                }
            }
        }
        catch (Exception e) {
            FlansMod.log("error parsing control packet");
            e.printStackTrace();
        }
    }

    @Override
    public byte getPacketID() {
        return 11;
    }
}

