/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.network;

import co.uk.flansmods.client.FlansModClient;
import co.uk.flansmods.client.model.GunAnimations;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.FlansModPlayerHandler;
import co.uk.flansmods.common.guns.BulletType;
import co.uk.flansmods.common.guns.GunType;
import co.uk.flansmods.common.guns.ItemBullet;
import co.uk.flansmods.common.guns.ItemGun;
import co.uk.flansmods.common.network.FlanPacketCommon;
import co.uk.flansmods.common.network.PacketPlaySound;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class PacketReload
extends FlanPacketCommon {
    public static final byte packetID = 19;

    public static Packet buildReloadPacket() {
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = channelFlan;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(19);
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            data.close();
            bytes.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packet;
    }

    @Override
    public void interpret(DataInputStream stream, Object[] extradata, Side side) {
        if (side.equals((Object)Side.CLIENT)) {
            this.interpretClient(stream, extradata);
        } else {
            this.interpretServer(stream, extradata);
        }
    }

    private void interpretServer(DataInputStream stream, Object[] extradata) {
        EntityPlayer player = (EntityPlayer)extradata[0];
        FlansModPlayerData data = FlansModPlayerHandler.getPlayerData(player);
        ItemStack stack = player.func_71045_bC();
        if (data != null && stack != null && stack.func_77973_b() instanceof ItemGun) {
            GunType type = ((ItemGun)stack.func_77973_b()).type;
            if (((ItemGun)stack.func_77973_b()).reload(stack, player.field_70170_p, player, true)) {
                data.shootTime = type.reloadTime;
                PacketDispatcher.sendPacketToPlayer((Packet)PacketReload.buildReloadPacket(), (Player)((Player)player));
                if (type.reloadSound != null) {
                    PacketDispatcher.sendPacketToAllAround((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)50.0, (int)player.field_71093_bK, (Packet)PacketPlaySound.buildSoundPacket(player.field_70165_t, player.field_70163_u, player.field_70161_v, type.reloadSound, false));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void interpretClient(DataInputStream stream, Object[] extradata) {
        try {
            EntityPlayer player = (EntityPlayer)extradata[0];
            ItemStack stack = player.func_71045_bC();
            if (stack != null && stack.func_77973_b() instanceof ItemGun) {
                GunType type = ((ItemGun)stack.func_77973_b()).type;
                FlansModClient.shootTime = type.reloadTime;
                GunAnimations animations = null;
                if (FlansModClient.gunAnimations.containsKey(player)) {
                    animations = FlansModClient.gunAnimations.get(player);
                } else {
                    animations = new GunAnimations();
                    FlansModClient.gunAnimations.put((EntityLivingBase)player, animations);
                }
                int pumpDelay = type.model == null ? 0 : type.model.pumpDelayAfterReload;
                int pumpTime = type.model == null ? 1 : type.model.pumpTime;
                animations.doReload(type.reloadTime, pumpDelay, pumpTime);
                int bestSlot = -1;
                int bulletsInBestSlot = 0;
                for (int j = 0; j < player.field_71071_by.func_70302_i_(); ++j) {
                    int bulletsInThisSlot;
                    ItemStack item = player.field_71071_by.func_70301_a(j);
                    if (item == null || !(item.func_77973_b() instanceof ItemBullet) || !type.isAmmo(((ItemBullet)item.func_77973_b()).type) || (bulletsInThisSlot = item.func_77958_k() - item.func_77960_j()) <= bulletsInBestSlot) continue;
                    bestSlot = j;
                    bulletsInBestSlot = bulletsInThisSlot;
                }
                if (bestSlot != -1) {
                    ItemStack newBulletStack = player.field_71071_by.func_70301_a(bestSlot);
                    BulletType newBulletType = ((ItemBullet)newBulletStack.func_77973_b()).type;
                    if (!player.field_71075_bZ.field_75098_d) {
                        --newBulletStack.field_77994_a;
                    }
                    if (newBulletStack.field_77994_a <= 0) {
                        newBulletStack = null;
                    }
                    player.field_71071_by.func_70299_a(bestSlot, newBulletStack);
                }
            }
        }
        catch (Exception e) {
            FlansMod.log("Error \"reload\"ing from reload packet");
            e.printStackTrace();
        }
    }

    @Override
    public byte getPacketID() {
        return 19;
    }
}

