/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.teams.EntityFlag;
import co.uk.flansmods.common.teams.ITeamBase;
import co.uk.flansmods.common.teams.ITeamObject;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityFlagpole
extends Entity
implements ITeamBase {
    public Team defaultTeam;
    public Team currentTeam;
    public TeamsManager.TeamsMap map;
    public List<ITeamObject> objects = new ArrayList<ITeamObject>();
    public String name = "Default Name";
    private int ID;
    private EntityFlag flag;
    public static TeamsManager teamsManager = TeamsManager.getInstance();
    private ForgeChunkManager.Ticket chunkTicket;
    private boolean uninitialized = true;
    private int loadDistance = 1;

    public EntityFlagpole(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.0f);
        this.field_70155_l = 100.0;
    }

    public EntityFlagpole(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
        this.flag = new EntityFlag(this.field_70170_p, this);
        this.objects.add(this.flag);
        this.field_70170_p.func_72838_d((Entity)this.flag);
        this.map = EntityFlagpole.teamsManager.currentMap;
    }

    public EntityFlagpole(World world, int x, int y, int z) {
        this(world, (double)x + 0.5, (double)y, (double)z + 0.5);
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tags) {
        this.setID(tags.func_74762_e("ID"));
        this.currentTeam = this.defaultTeam = Team.getTeam(tags.func_74779_i("Team"));
        if (this.currentTeam != null) {
            this.currentTeam.bases.add(this);
        }
        this.map = teamsManager.getTeamsMap(tags.func_74779_i("Map"));
    }

    protected void func_70014_b(NBTTagCompound tags) {
        if (this.defaultTeam != null) {
            tags.func_74778_a("Team", this.defaultTeam.shortName);
        }
        tags.func_74778_a("Map", this.map.shortName);
        tags.func_74768_a("ID", this.getID());
    }

    @Override
    public Team getOwner() {
        return this.currentTeam;
    }

    @Override
    public TeamsManager.TeamsMap getMap() {
        return this.map;
    }

    @Override
    public void setMap(TeamsManager.TeamsMap newMap) {
        this.map = newMap;
    }

    @Override
    public List<ITeamObject> getObjects() {
        return this.objects;
    }

    @Override
    public void setBase(Team newOwners) {
        this.updateOwners(newOwners);
        this.currentTeam = this.defaultTeam = newOwners;
    }

    @Override
    public void captureBase(Team newOwners) {
        this.updateOwners(newOwners);
        this.currentTeam = newOwners;
        TeamsManager.messageAll("\u00a7" + newOwners.textColour + newOwners.name + "\u00a7f captured " + this.name + "!");
    }

    public void updateOwners(Team newOwners) {
        ArrayList<EntityFlagpole> thisBase = new ArrayList<EntityFlagpole>();
        thisBase.add(this);
        for (Team team : Team.teams) {
            team.bases.removeAll(thisBase);
        }
        if (newOwners != null) {
            newOwners.bases.add(this);
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public void startRound() {
        this.updateOwners(this.defaultTeam);
        this.currentTeam = this.defaultTeam;
        for (ITeamObject object : this.getObjects()) {
            object.onBaseSet(this.defaultTeam);
        }
    }

    @Override
    public void addObject(ITeamObject object) {
        this.objects.add(object);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public void destroy() {
        this.func_70106_y();
    }

    @Override
    public Entity getEntity() {
        return this;
    }

    @Override
    public double getPosX() {
        return this.field_70165_t;
    }

    @Override
    public double getPosY() {
        return this.field_70163_u;
    }

    @Override
    public double getPosZ() {
        return this.field_70161_v;
    }

    @Override
    public World getWorld() {
        return this.field_70170_p;
    }

    @Override
    public void setID(int i) {
        this.ID = i;
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public ITeamObject getFlag() {
        return this.flag;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateChunkLoading();
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        this.chunkTicket = ticket;
        for (ChunkCoordIntPair coord : this.getLoadArea()) {
            FlansMod.log(String.format("Force loading chunk %s in %s", coord, this.field_70170_p.field_73011_w.getClass()));
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)coord);
        }
    }

    public List<ChunkCoordIntPair> getLoadArea() {
        LinkedList<ChunkCoordIntPair> loadArea = new LinkedList<ChunkCoordIntPair>();
        Chunk centerChunk = this.field_70170_p.func_72938_d(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v));
        loadArea.add(new ChunkCoordIntPair(centerChunk.field_76635_g, centerChunk.field_76647_h));
        return loadArea;
    }

    public void updateChunkLoading() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.uninitialized && this.chunkTicket == null) {
            this.chunkTicket = ForgeChunkManager.requestTicket((Object)FlansMod.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (this.chunkTicket != null) {
                this.forceChunkLoading(this.chunkTicket);
            }
            this.uninitialized = false;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (player instanceof EntityPlayerMP && TeamsManager.getInstance().currentGametype != null) {
            TeamsManager.getInstance().currentGametype.baseClickedByPlayer(this, (EntityPlayerMP)player);
        }
        return false;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        ItemStack stack = new ItemStack(FlansMod.flag.field_77779_bT, 1, 0);
        return stack;
    }
}

