/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.FlansModPlayerHandler;
import co.uk.flansmods.common.teams.Gametype;
import co.uk.flansmods.common.teams.ITeamBase;
import co.uk.flansmods.common.teams.ITeamObject;
import co.uk.flansmods.common.teams.PlayerClass;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class GametypeDM
extends Gametype {
    public int scoreLimit = 25;
    public int newRoundTimer = 0;
    public int time;

    public GametypeDM() {
        super("Deathmatch", "DM", 2);
    }

    @Override
    public void initGametype() {
        this.startNewRound();
    }

    @Override
    public void teamsSet() {
        this.startNewRound();
    }

    @Override
    public void startNewRound() {
        GametypeDM.respawnAll();
        for (EntityPlayer player : GametypeDM.getPlayers()) {
            GametypeDM.getPlayerData((EntityPlayerMP)((EntityPlayerMP)player)).playerClass = null;
            GametypeDM.getPlayerData((EntityPlayerMP)((EntityPlayerMP)player)).newPlayerClass = null;
            if (GametypeDM.getPlayerData((EntityPlayerMP)((EntityPlayerMP)player)).team == null) continue;
            GametypeDM.getPlayerData((EntityPlayerMP)((EntityPlayerMP)player)).team.removePlayer(player);
        }
        GametypeDM.resetScores();
        TeamsManager.messageAll("\u00a7fA new round has started!");
        if (GametypeDM.teamsManager.teams != null) {
            for (Team team : GametypeDM.teamsManager.teams) {
                if (team != null) continue;
                return;
            }
            GametypeDM.showTeamsMenuToAll(false);
        }
    }

    @Override
    public void stopGametype() {
        GametypeDM.resetScores();
    }

    @Override
    public void tick() {
        --this.newRoundTimer;
        if (this.newRoundTimer == 0) {
            if (FlansMod.useRotation) {
                TeamsManager.getInstance().switchToNextGametype();
                return;
            }
            this.startNewRound();
        }
        if (GametypeDM.teamsManager.teams != null) {
            for (Team team : GametypeDM.teamsManager.teams) {
                if (team == null) continue;
                for (String name : team.members) {
                    FlansModPlayerData data = FlansModPlayerHandler.getPlayerData(name);
                    if (data.score < this.scoreLimit || this.newRoundTimer >= 0) continue;
                    TeamsManager.messageAll(name + "\u00a7f won!");
                    this.newRoundTimer = 200;
                    TeamsManager.messageAll("\u00a7fThe next round will start in 10 seconds");
                    this.time = -300;
                }
            }
        }
        ++this.time;
    }

    @Override
    public void playerJoined(EntityPlayerMP player) {
        GametypeDM.sendTeamsMenuToPlayer(player);
    }

    @Override
    public boolean playerChoseTeam(EntityPlayerMP player, Team team, Team previousTeam) {
        if (previousTeam != null && previousTeam != Team.spectators && previousTeam != team && GametypeDM.isAValidTeam(previousTeam, true)) {
            ++GametypeDM.getPlayerData((EntityPlayerMP)player).deaths;
            --GametypeDM.getPlayerData((EntityPlayerMP)player).score;
            GametypeDM.getPlayerData((EntityPlayerMP)player).playerClass = null;
            GametypeDM.getPlayerData((EntityPlayerMP)player).newPlayerClass = null;
        }
        GametypeDM.sendClassMenuToPlayer(player);
        if (team != previousTeam) {
            teamsManager.forceRespawn(player);
        }
        return true;
    }

    @Override
    public boolean playerChoseClass(EntityPlayerMP player, PlayerClass playerClass) {
        Team team = GametypeDM.getPlayerData((EntityPlayerMP)player).team;
        if (!team.classes.contains(playerClass)) {
            return false;
        }
        GametypeDM.getPlayerData((EntityPlayerMP)player).newPlayerClass = playerClass;
        if (GametypeDM.getPlayerData((EntityPlayerMP)player).playerClass == null) {
            teamsManager.resetInventory((EntityPlayer)player);
        } else {
            player.func_71035_c("You will respawn with the " + playerClass.name.toLowerCase() + " class");
        }
        return true;
    }

    @Override
    public void playerQuit(EntityPlayerMP player) {
    }

    @Override
    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        if (GametypeDM.getPlayerData(player) == null || GametypeDM.getPlayerData((EntityPlayerMP)player).team == null) {
            return false;
        }
        if (this.newRoundTimer > 0) {
            return false;
        }
        EntityPlayerMP attacker = GametypeDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeDM.getPlayerData(attacker) == null || GametypeDM.getPlayerData((EntityPlayerMP)attacker).team == null) {
                return false;
            }
            if (GametypeDM.getPlayerData((EntityPlayerMP)attacker).team == Team.spectators) {
                return false;
            }
        }
        return GametypeDM.getPlayerData((EntityPlayerMP)player).team != Team.spectators;
    }

    @Override
    public void playerKilled(EntityPlayerMP player, DamageSource source) {
        EntityPlayerMP attacker = GametypeDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GametypeDM.getPlayerData((EntityPlayerMP)player).score;
            } else {
                ++GametypeDM.getPlayerData((EntityPlayerMP)attacker).score;
                ++GametypeDM.getPlayerData((EntityPlayerMP)attacker).kills;
            }
        } else {
            --GametypeDM.getPlayerData((EntityPlayerMP)player).score;
        }
        ++GametypeDM.getPlayerData((EntityPlayerMP)player).deaths;
    }

    @Override
    public void baseAttacked(ITeamBase base, DamageSource source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, DamageSource source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, EntityPlayerMP player) {
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, EntityPlayerMP player) {
    }

    @Override
    public Vec3 getSpawnPoint(EntityPlayerMP player) {
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        FlansModPlayerData data = GametypeDM.getPlayerData(player);
        if (data != null && data.team == Team.spectators) {
            for (int j = 0; j < data.team.bases.size(); ++j) {
                ITeamBase base = data.team.bases.get(j);
                if (base.getMap() != GametypeDM.teamsManager.currentMap) continue;
                for (int i = 0; i < base.getObjects().size(); ++i) {
                    if (!base.getObjects().get(i).isSpawnPoint()) continue;
                    validSpawnPoints.add(base.getObjects().get(i));
                }
            }
        } else {
            for (Team team : GametypeDM.teamsManager.teams) {
                for (int j = 0; j < data.team.bases.size(); ++j) {
                    ITeamBase base = data.team.bases.get(j);
                    if (base.getMap() != GametypeDM.teamsManager.currentMap) continue;
                    for (int i = 0; i < base.getObjects().size(); ++i) {
                        if (!base.getObjects().get(i).isSpawnPoint()) continue;
                        validSpawnPoints.add(base.getObjects().get(i));
                    }
                }
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return Vec3.func_72443_a((double)spawnPoint.getPosX(), (double)spawnPoint.getPosY(), (double)spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(EntityPlayerMP player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("scorelimit")) {
            this.scoreLimit = Integer.parseInt(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.scoreLimit = tags.func_74762_e("DMScoreLimit");
    }

    @Override
    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74768_a("DMScoreLimit", this.scoreLimit);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return false;
    }
}

