/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.addon.thaumcraft;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.mcft.copy.betterstorage.addon.thaumcraft.ThaumcraftAddon;
import net.mcft.copy.betterstorage.addon.thaumcraft.ThaumcraftResources;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import thaumcraft.api.IRepairable;
import thaumcraft.api.IRepairableExtended;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;

public class ItemThaumcraftBackpack
extends ItemBackpack
implements IRepairable,
IVisDiscountGear {
    public ItemThaumcraftBackpack(int id) {
        super(id, ItemBackpack.material);
        this.func_77656_e(288);
    }

    @Override
    public String getBackpackName() {
        return "container.betterstorage.thaumcraftBackpack";
    }

    @Override
    public int getBackpackColumns() {
        return 13;
    }

    @Override
    protected int getDefaultColor() {
        return -1;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return ThaumcraftResources.thaumcraftBackpackTexture.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        super.func_77624_a(stack, player, list, advancedTooltips);
        list.add(String.format("%s%s: %s%%", EnumChatFormatting.DARK_PURPLE, StatCollector.func_74838_a((String)"tc.visdiscount"), 2));
    }

    public int func_77619_b() {
        return 25;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return StackUtils.matches(stack, ThaumcraftAddon.fabric, false);
    }

    @Override
    public void onEquippedUpdate(EntityLivingBase entity, ItemStack backpack) {
        super.onEquippedUpdate(entity, backpack);
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            this.repairItems(backpack, (EntityPlayer)entity);
        }
    }

    public void repairItems(ItemStack stack, EntityPlayer player) {
        int time = 600;
        IInventory backpackInventory = ItemBackpack.getBackpackItems((EntityLivingBase)player);
        int backpackRepair = EnchantmentHelper.func_77506_a((int)ThaumcraftApi.enchantRepair, (ItemStack)stack);
        if (backpackRepair <= 0 || player.field_70173_aa % time > 0) {
            return;
        }
        for (int i = 0; i < backpackInventory.func_70302_i_(); ++i) {
            ItemStack itemStack = backpackInventory.func_70301_a(i);
            if (itemStack == null) continue;
            Item item = itemStack.func_77973_b();
            int repair = EnchantmentHelper.func_77506_a((int)ThaumcraftApi.enchantRepair, (ItemStack)itemStack);
            if (!(item instanceof IRepairable) || repair <= 0 || item instanceof IRepairableExtended && !((IRepairableExtended)item).doRepair(itemStack, player, repair)) continue;
            itemStack.func_77964_b(Math.max(itemStack.func_77960_j() - repair, 0));
        }
    }

    public int getVisDiscount(ItemStack stack, EntityPlayer player, Aspect aspect) {
        return 2;
    }
}

