/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.attachment;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.attachment.EnumAttachmentInteraction;
import net.mcft.copy.betterstorage.attachment.IAttachmentRenderer;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;

public abstract class Attachment {
    public final TileEntity tileEntity;
    public final int subId;
    private double x;
    private double y;
    private double z;
    private double width;
    private double height;
    private double depth;
    private AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    private ForgeDirection direction = ForgeDirection.NORTH;

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDepth() {
        return this.depth;
    }

    public float getRotation() {
        return DirectionUtils.getRotation(this.direction);
    }

    public AxisAlignedBB getHighlightBox() {
        return this.box.func_72329_c().func_72317_d((double)this.tileEntity.field_70329_l, (double)this.tileEntity.field_70330_m, (double)this.tileEntity.field_70327_n);
    }

    public Attachment(TileEntity tileEntity, int subId) {
        this.tileEntity = tileEntity;
        this.subId = subId;
    }

    public void setBox(double x, double y, double z, double width, double height, double depth, double scale) {
        this.x = x * scale;
        this.y = y * scale;
        this.z = z * scale;
        this.width = width * scale;
        this.height = height * scale;
        this.depth = depth * scale;
        this.updateBox();
    }

    public void setBox(double x, double y, double z, double width, double height, double depth) {
        this.setBox(x, y, z, width, height, depth, 0.0625);
    }

    public void setDirection(ForgeDirection direction) {
        this.direction = direction;
        this.updateBox();
    }

    private void updateBox() {
        double maxZ;
        double maxX;
        double minZ;
        double minX;
        double minY = 1.0 - (this.y + this.height / 2.0);
        double maxY = 1.0 - (this.y - this.height / 2.0);
        switch (this.direction) {
            case EAST: {
                minX = 1.0 - (this.z + this.depth / 2.0);
                minZ = this.x - this.width / 2.0;
                maxX = 1.0 - (this.z - this.depth / 2.0);
                maxZ = this.x + this.width / 2.0;
                break;
            }
            case SOUTH: {
                minX = 1.0 - (this.x + this.width / 2.0);
                minZ = 1.0 - (this.z + this.depth / 2.0);
                maxX = 1.0 - (this.x - this.width / 2.0);
                maxZ = 1.0 - (this.z - this.depth / 2.0);
                break;
            }
            case WEST: {
                minX = this.z - this.depth / 2.0;
                minZ = 1.0 - (this.x + this.width / 2.0);
                maxX = this.z + this.depth / 2.0;
                maxZ = 1.0 - (this.x - this.width / 2.0);
                break;
            }
            default: {
                minX = this.x - this.width / 2.0;
                minZ = this.z - this.depth / 2.0;
                maxX = this.x + this.width / 2.0;
                maxZ = this.z + this.depth / 2.0;
            }
        }
        this.box.func_72324_b(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void update() {
    }

    public boolean interact(EntityPlayer player, EnumAttachmentInteraction type) {
        return false;
    }

    public ItemStack pick() {
        return null;
    }

    public boolean boxVisible(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract IAttachmentRenderer getRenderer();
}

