/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.client.renderer;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.client.model.ModelBackpack;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.tile.entity.TileEntityBackpack;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.mcft.copy.betterstorage.utils.RenderUtils;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityBackpackRenderer
extends TileEntitySpecialRenderer {
    public void renderTileEntityAt(TileEntityBackpack backpack, double x, double y, double z, float partialTicks) {
        if (backpack.field_70331_k == null && backpack.field_70324_q == null) {
            return;
        }
        ItemBackpack item = (ItemBackpack)Item.field_77698_e[backpack.func_70311_o().field_71990_ca];
        ItemStack stack = backpack.stack != null ? backpack.stack : new ItemStack((Item)item);
        ModelBackpack backpackModel = item.getModel();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslated((double)x, (double)(y + 2.0), (double)(z + 1.0));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        ForgeDirection orientation = ForgeDirection.getOrientation((int)backpack.func_70322_n());
        int rotation = DirectionUtils.getRotation(orientation);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        float angle = backpack.prevLidAngle + (backpack.lidAngle - backpack.prevLidAngle) * partialTicks;
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle;
        backpackModel.setLidRotation((float)((double)angle * Math.PI / 4.0));
        int renderPasses = item.getRenderPasses(0);
        for (int pass = 0; pass < renderPasses; ++pass) {
            String type = pass == 0 ? null : "overlay";
            this.func_110628_a(new ResourceLocation(item.getArmorTexture(stack, null, 0, type)));
            RenderUtils.setColorFromInt(item.func_82790_a(stack, pass));
            backpackModel.renderAll();
        }
        if (backpack.stack != null && backpack.stack.func_77948_v()) {
            float f9 = ((float)backpack.ticksExisted + partialTicks) / 3.0f;
            this.func_110628_a(RendererLivingEntity.field_110814_a);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            GL11.glDepthMask((boolean)false);
            GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
            GL11.glEnable((int)32823);
            for (int k = 0; k < 2; ++k) {
                GL11.glDisable((int)2896);
                float f11 = 0.65f;
                GL11.glColor4f((float)(0.5f * f11), (float)(0.25f * f11), (float)(0.8f * f11), (float)1.0f);
                GL11.glBlendFunc((int)768, (int)1);
                GL11.glMatrixMode((int)5890);
                GL11.glLoadIdentity();
                float f12 = f9 * (0.001f + (float)k * 0.003f) * 20.0f;
                float f13 = 0.33333334f;
                GL11.glScalef((float)f13, (float)f13, (float)f13);
                GL11.glRotatef((float)(30.0f - (float)k * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)f12, (float)0.0f);
                GL11.glMatrixMode((int)5888);
                backpackModel.renderAll();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glDisable((int)32823);
            GL11.glPolygonOffset((float)0.0f, (float)0.0f);
            GL11.glDepthMask((boolean)true);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_76894_a(TileEntity entity, double x, double y, double z, float par8) {
        this.renderTileEntityAt((TileEntityBackpack)entity, x, y, z, par8);
    }
}

