/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.utils.MiscUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class ItemBetterStorage
extends Item {
    public static final String TAG_COLOR = "color";
    public static final String TAG_FULL_COLOR = "fullColor";
    public static final String TAG_KEYLOCK_ID = "id";
    private String name;

    public ItemBetterStorage(int id) {
        super(id - 256);
        this.func_77625_d(1);
        this.func_77637_a(BetterStorage.creativeTab);
        this.func_77655_b("betterstorage." + this.getItemName());
        GameRegistry.registerItem((Item)this, (String)this.getItemName());
    }

    public String getItemName() {
        return this.name != null ? this.name : (this.name = MiscUtils.getName(this));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("betterstorage:" + this.getItemName());
    }

    public static int getColor(ItemStack stack) {
        String type = StackUtils.getType(stack, TAG_FULL_COLOR);
        if (type == "BYTE") {
            return -1;
        }
        return StackUtils.get(stack, -1, TAG_COLOR);
    }

    public static void setColor(ItemStack stack, int color) {
        String type = StackUtils.getType(stack, TAG_FULL_COLOR);
        if (type == "BYTE") {
            int fullColor = StackUtils.get(stack, -1, TAG_COLOR);
            StackUtils.set(stack, fullColor, TAG_FULL_COLOR);
        }
        StackUtils.set(stack, color, TAG_COLOR);
    }

    public static int getFullColor(ItemStack stack) {
        String type = StackUtils.getType(stack, TAG_FULL_COLOR);
        if (type == "BYTE") {
            return StackUtils.get(stack, -1, TAG_COLOR);
        }
        if (type == "INT") {
            return StackUtils.get(stack, -1, TAG_FULL_COLOR);
        }
        return -1;
    }

    public static void setFullColor(ItemStack stack, int fullColor) {
        StackUtils.set(stack, fullColor, TAG_FULL_COLOR);
    }

    public static int getID(ItemStack stack) {
        return StackUtils.get(stack, 0, TAG_KEYLOCK_ID);
    }

    public static void setID(ItemStack stack, int id) {
        StackUtils.set(stack, id, TAG_KEYLOCK_ID);
    }
}

