/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.cardboard;

import java.util.Collection;
import net.mcft.copy.betterstorage.api.crafting.IRecipeInput;
import net.mcft.copy.betterstorage.api.crafting.IStationRecipe;
import net.mcft.copy.betterstorage.api.crafting.RecipeInputItemStack;
import net.mcft.copy.betterstorage.api.crafting.RecipeInputOreDict;
import net.mcft.copy.betterstorage.api.crafting.StationCrafting;
import net.mcft.copy.betterstorage.item.cardboard.CardboardRecipeHelper;
import net.mcft.copy.betterstorage.item.cardboard.ICardboardItem;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.item.ItemStack;

public class CardboardRepairRecipe
implements IStationRecipe {
    private static final IRecipeInput sheetUsed = new RecipeInputOreDict("sheetCardboard", 1);
    private static final IRecipeInput sheetUnused = new RecipeInputOreDict("sheetCardboard", 0);

    @Override
    public StationCrafting checkMatch(ItemStack[] input) {
        boolean hasCardboardItems = false;
        int numSheets = 0;
        int totalDamage = 0;
        for (int i = 0; i < input.length; ++i) {
            ItemStack stack = input[i];
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof ICardboardItem) {
                hasCardboardItems = true;
                totalDamage += stack.func_77960_j();
                continue;
            }
            if (sheetUsed.matches(stack)) {
                ++numSheets;
                continue;
            }
            return null;
        }
        if (!hasCardboardItems || numSheets <= 0) {
            return null;
        }
        int numSheetsNeeded = (totalDamage + 79) / 80;
        if (numSheetsNeeded > numSheets) {
            return null;
        }
        ItemStack[] output = new ItemStack[9];
        int experienceCost = 0;
        IRecipeInput[] requiredInput = new IRecipeInput[9];
        for (int i = 0; i < input.length; ++i) {
            ItemStack stack = input[i];
            if (stack == null) continue;
            ItemStack outputStack = null;
            if (stack.func_77973_b() instanceof ICardboardItem) {
                Collection<StackUtils.StackEnchantment> enchantments = StackUtils.getEnchantments(stack).values();
                experienceCost += Math.max(enchantments.size() - 1, 0);
                for (StackUtils.StackEnchantment ench : enchantments) {
                    experienceCost += this.calculateCost(ench);
                }
                outputStack = StackUtils.copyStack(stack, 1);
                outputStack.func_77964_b(0);
                ItemStack requiredStack = outputStack.func_77946_l();
                requiredStack.func_77964_b(Short.MAX_VALUE);
                requiredStack.func_77982_d(null);
                requiredInput[i] = new RecipeInputItemStack(requiredStack);
            } else {
                requiredInput[i] = numSheetsNeeded-- > 0 ? sheetUsed : sheetUnused;
            }
            output[i] = outputStack;
        }
        return new StationCrafting(output, requiredInput, experienceCost);
    }

    private int calculateCost(StackUtils.StackEnchantment ench) {
        int cost = 0;
        int weight = ench.ench.func_77324_c();
        int level = ench.getLevel();
        cost = weight > 8 ? (cost += Math.max(level - 2, 0)) : (weight > 4 ? (cost += level - 1) : (weight > 2 ? (cost += level) : level * 2));
        return cost += CardboardRecipeHelper.getAdditionalEnchantmentCost(ench);
    }
}

