/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.locking;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.api.BetterStorageEnchantment;
import net.mcft.copy.betterstorage.api.lock.IKey;
import net.mcft.copy.betterstorage.api.lock.ILock;
import net.mcft.copy.betterstorage.item.ItemBetterStorage;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemKey
extends ItemBetterStorage
implements IKey {
    private Icon iconColor;
    private Icon iconFullColor;

    public ItemKey(int id) {
        super(id);
        this.func_77642_a(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.iconColor = iconRegister.func_94245_a("betterstorage:key_color");
        this.iconFullColor = iconRegister.func_94245_a("betterstorage:key_fullColor");
    }

    public boolean func_77645_m() {
        return true;
    }

    public int func_77619_b() {
        return 20;
    }

    public boolean func_77630_h(ItemStack stack) {
        return false;
    }

    public ItemStack getContainerItemStack(ItemStack stack) {
        return stack;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            ItemKey.ensureHasID(stack);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isBeingHeld) {
        if (!world.field_72995_K) {
            ItemKey.ensureHasID(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        int fullColor = ItemKey.getFullColor(stack);
        if (fullColor < 0) {
            fullColor = 0xFFFFFF;
        }
        if (renderPass > 0) {
            int color = ItemKey.getColor(stack);
            return color < 0 ? fullColor : color;
        }
        return fullColor;
    }

    public Icon getIcon(ItemStack stack, int renderPass) {
        boolean hasFullColor;
        boolean bl = hasFullColor = ItemKey.getFullColor(stack) >= 0;
        if (renderPass > 0 && ItemKey.getColor(stack) >= 0) {
            return this.iconColor;
        }
        return hasFullColor ? this.iconFullColor : this.field_77791_bV;
    }

    public static void ensureHasID(ItemStack stack) {
        if (!StackUtils.has(stack, "id")) {
            ItemKey.setID(stack, RandomUtils.getInt(1, 32000));
        }
    }

    @Override
    public boolean isNormalKey() {
        return true;
    }

    @Override
    public boolean unlock(ItemStack key, ItemStack lock, boolean useAbility) {
        int div;
        int keyId;
        ILock lockType = (ILock)lock.func_77973_b();
        if (lockType.getLockType() != "normal") {
            return false;
        }
        int lockId = ItemKey.getID(lock);
        if (lockId == (keyId = ItemKey.getID(key))) {
            return true;
        }
        int lockSecurity = BetterStorageEnchantment.getLevel(lock, "security");
        int unlocking = BetterStorageEnchantment.getLevel(key, "unlocking");
        int lockpicking = BetterStorageEnchantment.getLevel(key, "lockpicking");
        int morphing = BetterStorageEnchantment.getLevel(key, "morphing");
        int effectiveUnlocking = Math.max(0, unlocking - lockSecurity);
        int effectiveLockpicking = Math.max(0, lockpicking - lockSecurity);
        int effectiveMorphing = Math.max(0, morphing - lockSecurity);
        if (effectiveUnlocking > 0 && lockId / (div = (int)Math.pow(2.0, 10 + effectiveUnlocking * 1)) == keyId / div) {
            return true;
        }
        if (useAbility && effectiveLockpicking > 0) {
            NBTTagList list = key.func_77986_q();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = (NBTTagCompound)list.func_74743_b(i);
                if (compound.func_74765_d("id") != BetterStorageEnchantment.get((String)"lockpicking").field_77352_x) continue;
                int level = compound.func_74765_d("lvl") - 1;
                if (level == 0) {
                    list.func_74744_a(i);
                    if (list.func_74745_c() != 0) break;
                    key.func_77978_p().func_82580_o("ench");
                    break;
                }
                compound.func_74777_a("lvl", (short)level);
                break;
            }
            return true;
        }
        if (useAbility && effectiveMorphing > 0) {
            key.func_77964_b(lockId);
            NBTTagList list = key.func_77986_q();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = (NBTTagCompound)list.func_74743_b(i);
                if (compound.func_74765_d("id") != BetterStorageEnchantment.get((String)"morphing").field_77352_x) continue;
                list.func_74744_a(i);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canApplyEnchantment(ItemStack key, Enchantment enchantment) {
        return true;
    }
}

