/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.recipe;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public abstract class ComboRecipe
implements IRecipe {
    public int width;
    public int height;
    public ItemStack[] recipe;
    public ItemStack result;

    public ComboRecipe(int width, int height, ItemStack[] recipe, ItemStack result) {
        this.width = width;
        this.height = height;
        this.recipe = recipe;
        this.result = result;
    }

    public int func_77570_a() {
        return this.width * this.height;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public boolean func_77569_a(InventoryCrafting crafting, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(crafting, x, y, false)) {
                    return true;
                }
                if (!this.canMirror() || !this.checkMatch(crafting, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canMirror() {
        return false;
    }

    public abstract boolean checkShapelessItems(InventoryCrafting var1, List<ItemStack> var2);

    private boolean checkMatch(InventoryCrafting crafting, int startX, int startY, boolean mirror) {
        ArrayList<ItemStack> shapelessItems = new ArrayList<ItemStack>();
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack craftingStack;
                int recipeX = x - startX;
                int recipeY = y - startY;
                ItemStack recipeStack = null;
                if (recipeX >= 0 && recipeY >= 0 && recipeX < this.width && recipeY < this.height) {
                    recipeStack = mirror ? this.recipe[this.width - recipeX - 1 + recipeY * this.width] : this.recipe[recipeX + recipeY * this.width];
                }
                if ((craftingStack = crafting.func_70463_b(x, y)) == null && recipeStack == null) continue;
                if (recipeStack != null && craftingStack == null) {
                    return false;
                }
                if (recipeStack == null && craftingStack != null) {
                    shapelessItems.add(craftingStack);
                    continue;
                }
                if (recipeStack.field_77993_c != craftingStack.field_77993_c) {
                    return false;
                }
                if (recipeStack.func_77960_j() == Short.MAX_VALUE || recipeStack.func_77960_j() == craftingStack.func_77960_j()) continue;
                return false;
            }
        }
        return shapelessItems.size() <= 0 || this.checkShapelessItems(crafting, shapelessItems);
    }
}

