/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.recipe;

import java.util.List;
import net.mcft.copy.betterstorage.content.Items;
import net.mcft.copy.betterstorage.item.ItemBetterStorage;
import net.mcft.copy.betterstorage.item.recipe.ComboRecipe;
import net.mcft.copy.betterstorage.utils.DyeUtils;
import net.mcft.copy.betterstorage.utils.InventoryUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LockColorRecipe
extends ComboRecipe {
    private LockColorRecipe(ItemStack[] recipe, ItemStack result) {
        super(1, 1, recipe, result);
    }

    @Override
    public boolean func_77569_a(InventoryCrafting crafting, World world) {
        if (!super.func_77569_a(crafting, world)) {
            return false;
        }
        int items = 0;
        for (int i = 0; i < crafting.func_70302_i_(); ++i) {
            if (crafting.func_70301_a(i) == null) continue;
            ++items;
        }
        return items > 1;
    }

    @Override
    public boolean checkShapelessItems(InventoryCrafting crafting, List<ItemStack> shapelessItems) {
        List<ItemStack> locks = InventoryUtils.findItems((IInventory)crafting, Items.lock);
        if (locks.size() > 1) {
            return false;
        }
        for (ItemStack stack : shapelessItems) {
            if (stack.func_77973_b() == Items.lock || DyeUtils.isDye(stack)) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting crafting) {
        ItemStack lock = InventoryUtils.findItem((IInventory)crafting, Items.lock);
        List<ItemStack> dyes = InventoryUtils.findDyes((IInventory)crafting);
        ItemStack result = lock.func_77946_l();
        if (dyes.size() > 0) {
            int color = DyeUtils.getColorFromDyes(dyes);
            if (dyes.size() >= 8) {
                ItemBetterStorage.setFullColor(result, color);
            } else {
                ItemBetterStorage.setColor(result, color);
            }
        }
        return result;
    }

    public static LockColorRecipe createLockColorRecipe() {
        ItemStack lock = new ItemStack((Item)Items.lock);
        return new LockColorRecipe(new ItemStack[]{lock}, lock);
    }
}

