/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public abstract class ConnectedTexture {
    private static final String[] iconNames = new String[]{"all", "none", "t", "b", "l", "r", "tl", "tr", "bl", "br", "tlr", "tbl", "tbr", "blr", "tb", "lr"};
    private static final int[][] connectedLookup = new int[][]{{2, 3, 4, 5}, {2, 3, 4, 5}, {1, 0, 5, 4}, {1, 0, 4, 5}, {1, 0, 2, 3}, {1, 0, 3, 2}};
    private Map<String, Icon> icons = new HashMap<String, Icon>();

    public void registerIcons(IconRegister iconRegister, String format) {
        for (String name : iconNames) {
            this.icons.put(name, iconRegister.func_94245_a(String.format(format, name)));
        }
    }

    public Icon getIcon(String name) {
        return this.icons.get(name);
    }

    public Icon getConnectedIcon(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        boolean top = this.canConnect(world, x, y, z, side, ForgeDirection.getOrientation((int)connectedLookup[side.ordinal()][0]));
        boolean bottom = this.canConnect(world, x, y, z, side, ForgeDirection.getOrientation((int)connectedLookup[side.ordinal()][1]));
        boolean left = this.canConnect(world, x, y, z, side, ForgeDirection.getOrientation((int)connectedLookup[side.ordinal()][2]));
        boolean right = this.canConnect(world, x, y, z, side, ForgeDirection.getOrientation((int)connectedLookup[side.ordinal()][3]));
        StringBuilder iconName = new StringBuilder();
        if (!top) {
            iconName.append('t');
        }
        if (!bottom) {
            iconName.append('b');
        }
        if (!left) {
            iconName.append('l');
        }
        if (!right) {
            iconName.append('r');
        }
        return this.getIcon(iconName.length() <= 0 ? "none" : (iconName.length() >= 4 ? "all" : iconName.toString()));
    }

    public abstract boolean canConnect(IBlockAccess var1, int var2, int var3, int var4, ForgeDirection var5, ForgeDirection var6);
}

