/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class Region {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;

    public int width() {
        return this.maxX - this.minX + 1;
    }

    public int depth() {
        return this.maxY - this.minY + 1;
    }

    public int height() {
        return this.maxZ - this.minZ + 1;
    }

    public int volume() {
        return this.width() * this.depth() * this.height();
    }

    public Region(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Region(TileEntity entity) {
        this(entity.field_70329_l, entity.field_70330_m, entity.field_70327_n, entity.field_70329_l, entity.field_70330_m, entity.field_70327_n);
    }

    public void set(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public void expand(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX -= minX;
        this.minY -= minY;
        this.minZ -= minZ;
        this.maxX += maxX;
        this.maxY += maxY;
        this.maxZ += maxZ;
    }

    public void expand(int size) {
        this.expand(size, size, size, size, size, size);
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.minX && y >= this.minY && z >= this.minZ && x <= this.maxX && y <= this.maxY && z <= this.maxZ;
    }

    public boolean contains(TileEntity entity) {
        return this.contains(entity.field_70329_l, entity.field_70330_m, entity.field_70327_n);
    }

    public void expandToContain(int x, int y, int z) {
        this.minX = Math.min(this.minX, x);
        this.minY = Math.min(this.minY, y);
        this.minZ = Math.min(this.minZ, z);
        this.maxX = Math.max(this.maxX, x);
        this.maxY = Math.max(this.maxY, y);
        this.maxZ = Math.max(this.maxZ, z);
    }

    public void expandToContain(TileEntity entity) {
        this.expandToContain(entity.field_70329_l, entity.field_70330_m, entity.field_70327_n);
    }

    public NBTTagCompound toCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("minX", this.minX);
        compound.func_74768_a("minY", this.minY);
        compound.func_74768_a("minZ", this.minZ);
        compound.func_74768_a("maxX", this.maxX);
        compound.func_74768_a("maxY", this.maxY);
        compound.func_74768_a("maxZ", this.maxZ);
        return compound;
    }

    public static Region fromCompound(NBTTagCompound compound) {
        int minX = compound.func_74762_e("minX");
        int minY = compound.func_74762_e("minY");
        int minZ = compound.func_74762_e("minZ");
        int maxX = compound.func_74762_e("maxX");
        int maxY = compound.func_74762_e("maxY");
        int maxZ = compound.func_74762_e("maxZ");
        return new Region(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Region clone() {
        return new Region(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public String toString() {
        return "[ " + this.minX + "," + this.minY + "," + this.minZ + " : " + this.maxX + "," + this.maxY + "," + this.maxZ + " ]";
    }
}

