/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.proxy.ClientProxy;
import net.mcft.copy.betterstorage.tile.TileContainerBetterStorage;
import net.mcft.copy.betterstorage.tile.entity.TileEntityBackpack;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileBackpack
extends TileContainerBetterStorage {
    boolean lastSneaking = false;
    private long lastHelpMessage = System.currentTimeMillis();

    public TileBackpack(int id) {
        super(id, Material.field_76253_m);
        this.func_71848_c(1.5f);
        this.func_71884_a(field_71975_k);
        float w = (float)this.getBoundsWidth() / 16.0f;
        float h = (float)this.getBoundsHeight() / 16.0f;
        this.func_71905_a(0.5f - w / 2.0f, 0.0f, 0.5f - w / 2.0f, 0.5f + w / 2.0f, h, 0.5f + w / 2.0f);
    }

    public int getBoundsWidth() {
        return 12;
    }

    public int getBoundsHeight() {
        return 13;
    }

    public int getBoundsDepth() {
        return 10;
    }

    @Override
    public Class<? extends Item> getItemClass() {
        return ItemBackpack.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.field_94336_cN = iconRegister.func_94245_a("wool_colored_brown");
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        float w = (float)this.getBoundsWidth() / 16.0f;
        float h = (float)this.getBoundsHeight() / 16.0f;
        float d = (float)this.getBoundsDepth() / 16.0f;
        ForgeDirection orientation = ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z));
        if (orientation == ForgeDirection.NORTH || orientation == ForgeDirection.SOUTH) {
            this.func_71905_a(0.5f - w / 2.0f, 0.0f, 0.5f - d / 2.0f, 0.5f + w / 2.0f, h, 0.5f + d / 2.0f);
        } else if (orientation == ForgeDirection.WEST || orientation == ForgeDirection.EAST) {
            this.func_71905_a(0.5f - d / 2.0f, 0.0f, 0.5f - w / 2.0f, 0.5f + d / 2.0f, h, 0.5f + w / 2.0f);
        } else {
            this.func_71905_a(0.5f - w / 2.0f, 0.0f, 0.5f - w / 2.0f, 0.5f + w / 2.0f, h, 0.5f + w / 2.0f);
        }
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return ClientProxy.backpackRenderId;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }

    public float func_71908_a(EntityPlayer player, World world, int x, int y, int z) {
        float hardness = super.func_71908_a(player, world, x, y, z);
        boolean sneaking = player.func_70093_af();
        boolean canEquip = ItemBackpack.canEquipBackpack(player);
        boolean stoppedSneaking = this.localPlayerStoppedSneaking(player);
        return stoppedSneaking || sneaking && !canEquip ? -1.0f : hardness * (float)(sneaking ? 4 : 1);
    }

    private boolean localPlayerStoppedSneaking(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K || player != Minecraft.func_71410_x().field_71439_g) {
            return false;
        }
        boolean stoppedSneaking = !player.func_70093_af() && this.lastSneaking;
        this.lastSneaking = player.func_70093_af();
        return stoppedSneaking;
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K && player.func_70093_af() && !ItemBackpack.canEquipBackpack(player) && BetterStorage.globalConfig.getBoolean("settings.enableHelpTooltips") && System.currentTimeMillis() > this.lastHelpMessage + 10000L) {
            boolean backpack = ItemBackpack.getBackpack((EntityLivingBase)player) != null;
            player.func_71035_c("tile.betterstorage.backpack.cantEquip." + (backpack ? "backpack" : "chestplate"));
            this.lastHelpMessage = System.currentTimeMillis();
        }
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityBackpack();
    }
}

