/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile;

import java.util.List;
import java.util.Random;
import net.mcft.copy.betterstorage.api.BetterStorageEnchantment;
import net.mcft.copy.betterstorage.attachment.Attachments;
import net.mcft.copy.betterstorage.attachment.EnumAttachmentInteraction;
import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.tile.ContainerMaterial;
import net.mcft.copy.betterstorage.tile.TileContainerBetterStorage;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLockable;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TileLockable
extends TileContainerBetterStorage {
    protected TileLockable(int id, Material material) {
        super(id, material);
    }

    public boolean hasMaterial() {
        return true;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        if (!this.hasMaterial()) {
            super.func_71879_a(id, tab, list);
        } else {
            for (ContainerMaterial material : ContainerMaterial.getMaterials()) {
                list.add(material.setMaterial(new ItemStack(id, 1, 0)));
            }
        }
    }

    @Override
    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (this.hasMaterial() && !player.field_71075_bZ.field_75098_d) {
            this.func_71929_a(world, x, y, z, WorldUtils.get((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityLockable.class).material.setMaterial(new ItemStack(this.field_71990_ca, 1, 0)));
        }
        return super.removeBlockByPlayer(world, player, x, y, z);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (this.hasMaterial()) {
            this.func_71929_a(world, x, y, z, WorldUtils.get((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityLockable.class).material.setMaterial(new ItemStack(this.field_71990_ca, 1, 0)));
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return this.hasMaterial() ? 0 : 1;
    }

    public float func_71934_m(World world, int x, int y, int z) {
        TileEntityLockable lockable = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockable.class);
        if (lockable != null && lockable.getLock() != null) {
            return -1.0f;
        }
        return super.func_71934_m(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int persistance;
        float modifier = 1.0f;
        TileEntityLockable lockable = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockable.class);
        if (lockable != null && (persistance = BetterStorageEnchantment.getLevel(lockable.getLock(), "persistance")) > 0) {
            modifier = (float)((double)modifier + Math.pow(2.0, persistance));
        }
        return super.func_71904_a(entity) * modifier;
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        return WorldUtils.get((IBlockAccess)world, x, y, z, IHasAttachments.class).getAttachments().rayTrace(world, x, y, z, start, end);
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        Attachments attachments = WorldUtils.get((IBlockAccess)world, x, y, z, IHasAttachments.class).getAttachments();
        boolean abort = attachments.interact(WorldUtils.rayTrace(player, 1.0f), player, EnumAttachmentInteraction.attack);
    }

    public boolean func_96468_q_() {
        return true;
    }

    public boolean func_71853_i() {
        return true;
    }

    public int func_71865_a(IBlockAccess world, int x, int y, int z, int side) {
        return WorldUtils.get(world, x, y, z, TileEntityLockable.class).isPowered() ? 15 : 0;
    }

    public int func_71855_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_71865_a(world, x, y, z, side);
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockable.class).setPowered(false);
    }
}

