/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import net.mcft.copy.betterstorage.content.Tiles;
import net.mcft.copy.betterstorage.inventory.InventoryCardboardBox;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.item.tile.ItemCardboardBox;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class TileEntityCardboardBox
extends TileEntityContainer {
    public boolean moved = false;

    @Override
    public String getName() {
        return "container.betterstorage.cardboardBox";
    }

    @Override
    public int getRows() {
        return ItemCardboardBox.getRows();
    }

    @Override
    public InventoryTileEntity makePlayerInventory() {
        return new InventoryTileEntity((TileEntityContainer)this, new InventoryCardboardBox(this.contents));
    }

    @Override
    public void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlaced(player, stack);
        if (!StackUtils.has(stack, "Items")) {
            return;
        }
        ItemStack[] itemContents = StackUtils.getStackContents(stack, this.contents.length);
        System.arraycopy(itemContents, 0, this.contents, 0, itemContents.length);
        if (!ItemCardboardBox.isReusable()) {
            this.moved = true;
        }
    }

    @Override
    public void onBlockDestroyed() {
        if (!this.moved) {
            boolean empty = StackUtils.isEmpty(this.contents);
            ItemStack stack = new ItemStack((Block)Tiles.cardboardBox);
            if (!empty) {
                StackUtils.setStackContents(stack, this.contents);
            }
            if (!empty || !this.brokenInCreative) {
                WorldUtils.dropStackFromBlock(this, stack);
            }
        }
        super.onBlockDestroyed();
    }

    @Override
    public void dropContents() {
        if (this.moved) {
            super.dropContents();
        }
    }
}

