/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.mcft.copy.betterstorage.utils.PlayerUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;

public abstract class TileEntityContainer
extends TileEntity {
    public final ItemStack[] contents;
    private final InventoryTileEntity playerInventory;
    private String customTitle = null;
    private int playersUsing = 0;
    protected boolean brokenInCreative = false;
    public int ticksExisted = 0;
    public float lidAngle = 0.0f;
    public float prevLidAngle = 0.0f;
    private boolean compAccessedOnLoad = false;
    private boolean compAccessed = false;
    private boolean compContentsChanged = false;

    public int getColumns() {
        return 9;
    }

    public int getRows() {
        return 3;
    }

    protected int getSizeContents() {
        return this.getColumns() * this.getRows();
    }

    public abstract String getName();

    public final int getPlayersUsing() {
        return this.playersUsing;
    }

    public TileEntityContainer() {
        int size = this.getSizeContents();
        this.contents = size > 0 ? new ItemStack[size] : null;
        this.playerInventory = this.makePlayerInventory();
    }

    public InventoryTileEntity makePlayerInventory() {
        return this.contents != null ? new InventoryTileEntity(this) : null;
    }

    public InventoryTileEntity getPlayerInventory() {
        return this.playerInventory;
    }

    public boolean canPlayerUseContainer(EntityPlayer player) {
        return WorldUtils.isTileEntityUsableByPlayer(this, player);
    }

    public ContainerBetterStorage createContainer(EntityPlayer player) {
        return new ContainerBetterStorage(player, this.getPlayerInventory());
    }

    public String getContainerTitle() {
        return this.hasCustomTitle() ? this.getCustomTitle() : this.getName();
    }

    public String getCustomTitle() {
        return this.customTitle;
    }

    public boolean hasCustomTitle() {
        return this.getCustomTitle() != null;
    }

    public boolean shouldLocalizeTitle() {
        return !this.hasCustomTitle();
    }

    public boolean canSetCustomTitle() {
        return true;
    }

    public void setCustomTitle(String title) {
        if (this.canSetCustomTitle()) {
            this.customTitle = title;
        }
    }

    public void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        if (stack.func_82837_s()) {
            this.setCustomTitle(stack.func_82833_r());
        }
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (this.field_70331_k.field_72995_K) {
            return true;
        }
        if (!this.canPlayerUseContainer(player)) {
            return true;
        }
        this.openGui(player);
        return true;
    }

    public void openGui(EntityPlayer player) {
        ContainerBetterStorage container = this.createContainer(player);
        PlayerUtils.openGui(player, this.getName(), container.getColumns(), container.getRows(), this.getCustomTitle(), container);
    }

    public ItemStack onPickBlock(ItemStack block, MovingObjectPosition target) {
        return block;
    }

    public boolean onBlockBreak(EntityPlayer player) {
        this.brokenInCreative = player.field_71075_bZ.field_75098_d;
        return true;
    }

    public void onBlockDestroyed() {
        this.dropContents();
        this.brokenInCreative = false;
    }

    public void dropContents() {
        if (this.contents != null) {
            for (ItemStack stack : this.contents) {
                WorldUtils.dropStackFromBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onBlockRenderAsItem(ItemStack stack) {
    }

    protected boolean hasComparatorAccessed() {
        return this.compAccessed;
    }

    protected boolean hasContentsChanged() {
        return this.compContentsChanged;
    }

    public static int getContainerComparatorSignalStrength(IBlockAccess world, int x, int y, int z) {
        TileEntityContainer container = WorldUtils.get(world, x, y, z, TileEntityContainer.class);
        return container != null ? container.getComparatorSignalStrength() : 0;
    }

    public int getComparatorSignalStrength() {
        this.markComparatorAccessed();
        return this.getComparatorSignalStengthInternal();
    }

    protected void markComparatorAccessed() {
        this.compAccessed = true;
    }

    protected void markContentsChanged() {
        this.compContentsChanged = true;
    }

    protected int getComparatorSignalStengthInternal() {
        return this instanceof IInventory ? Container.func_94526_b((IInventory)((IInventory)this)) : 0;
    }

    protected void comparatorUpdateAndReset() {
        this.compAccessed = false;
        this.compContentsChanged = false;
        this.field_70331_k.func_96440_m(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
    }

    public void func_70296_d() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.field_70331_k.func_72944_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, (TileEntity)this);
        if (this.hasComparatorAccessed()) {
            this.markContentsChanged();
        }
    }

    public void func_70312_q() {
        if (this.compAccessedOnLoad) {
            this.markComparatorAccessed();
            this.compAccessedOnLoad = false;
        }
    }

    protected boolean doesSyncPlayers() {
        return false;
    }

    protected boolean syncPlayersUsing() {
        return !this.field_70331_k.field_72995_K && this.doesSyncPlayers() && (this.ticksExisted + this.field_70329_l + this.field_70330_m + this.field_70327_n & 0xFF) == 0 && this.field_70331_k.func_72873_a(this.field_70329_l, this.field_70330_m, this.field_70327_n, 16);
    }

    private void doSyncPlayersUsing(int playersUsing) {
        if (!this.doesSyncPlayers()) {
            return;
        }
        this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, 0, playersUsing);
    }

    public boolean func_70315_b(int event, int value) {
        if (event == 0) {
            this.playersUsing = value;
        }
        return true;
    }

    public void onContainerOpened() {
        this.doSyncPlayersUsing(++this.playersUsing);
    }

    public void onContainerClosed() {
        this.doSyncPlayersUsing(--this.playersUsing);
    }

    protected float getLidSpeed() {
        return 0.1f;
    }

    public void func_70316_g() {
        int newPlayersUsing;
        ++this.ticksExisted;
        if (this.hasComparatorAccessed() && this.hasContentsChanged()) {
            this.comparatorUpdateAndReset();
        }
        if (this.syncPlayersUsing() && (newPlayersUsing = WorldUtils.syncPlayersUsing(this, this.playersUsing)) != this.playersUsing) {
            this.playersUsing = newPlayersUsing;
            this.doSyncPlayersUsing(this.playersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        if (this.playersUsing > 0) {
            if (this.lidAngle < 1.0f) {
                this.lidAngle = Math.min(1.0f, this.lidAngle + this.getLidSpeed());
            }
        } else if (this.lidAngle > 0.0f) {
            this.lidAngle = Math.max(0.0f, this.lidAngle - this.getLidSpeed());
        }
    }

    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        if (compound.func_74764_b("CustomName")) {
            this.customTitle = compound.func_74779_i("CustomName");
        }
        if (this.contents != null) {
            NbtUtils.readItems(this.contents, compound.func_74761_m("Items"));
        }
        if (compound.func_74767_n("ComparatorAccessed")) {
            this.compAccessedOnLoad = true;
        }
    }

    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        if (this.customTitle != null) {
            compound.func_74778_a("CustomName", this.customTitle);
        }
        if (this.contents != null) {
            compound.func_74782_a("Items", (NBTBase)NbtUtils.writeItems(this.contents));
        }
        if (this.hasComparatorAccessed()) {
            compound.func_74757_a("ComparatorAccessed", true);
        }
    }

    public void markForUpdate() {
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.func_70296_d();
    }
}

